/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_BootSourceSetting.h"

CMPIObjectPath* Boot_OpenDRIM_BootSourceSetting_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_BootSourceSetting& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_BootSourceSetting_classnames[0], OpenDRIM_BootSourceSetting_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* Boot_OpenDRIM_BootSourceSetting_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_BootSourceSetting& instance) {
	_E_;
	Objectpath op(broker, Boot_OpenDRIM_BootSourceSetting_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.BootString_isNULL)
		ci.setProperty("BootString", instance.BootString);

	if (!instance.BIOSBootString_isNULL)
		ci.setProperty("BIOSBootString", instance.BIOSBootString);

	if (!instance.StructuredBootString_isNULL)
		ci.setProperty("StructuredBootString", instance.StructuredBootString);

	if (!instance.FailThroughSupported_isNULL)
		ci.setProperty("FailThroughSupported", instance.FailThroughSupported);

	_L_;
	return ci.getHdl();
}

void Boot_OpenDRIM_BootSourceSetting_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_BootSourceSetting& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void Boot_OpenDRIM_BootSourceSetting_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_BootSourceSetting& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("BootString", instance.BootString) == OK)
		instance.BootString_isNULL = false;

	if (inst.getProperty("BIOSBootString", instance.BIOSBootString) == OK)
		instance.BIOSBootString_isNULL = false;

	if (inst.getProperty("StructuredBootString", instance.StructuredBootString) == OK)
		instance.StructuredBootString_isNULL = false;

	if (inst.getProperty("FailThroughSupported", instance.FailThroughSupported) == OK)
		instance.FailThroughSupported_isNULL = false;

	_L_;
}

