/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "ProgressBar.h"

#include <iomanip>
#include <iostream>
#include <sstream>

using namespace shivanimator;

ProgressBar::ProgressBar(GTLCore::String title, unsigned int cptMax, unsigned int barWidth) :
  m_barWidth(barWidth - title.length() - 1),
  m_cpt(0),
  m_cptMax(cptMax),
  m_title(title),
  m_time(llvm::sys::TimeValue::now())
{
  bar();
}

ProgressBar::~ProgressBar()
{
  std::cout << std::endl;
}

void ProgressBar::next()
{
  ++m_cpt;
  bar();
}

void ProgressBar::bar()
{
  double d = double(m_cpt)/double(m_cptMax);

  std::ostringstream buf;

  buf << m_title << " " << std::setw(3) << int(100*d) << "%[";
  unsigned int i = 0;
  while (i < d*m_barWidth) {
    buf << "=";
    ++i;
  }
  if (i<m_barWidth) {
    buf << ">";
    ++i;
  }
  while (i<m_barWidth) {
    buf << " ";
    ++i;
  }
  buf << "] ";

  llvm::sys::TimeValue now = llvm::sys::TimeValue::now();
  now -= m_time;
  buf << now.seconds() << " s";
  
  std::cout << "\r" << buf.str() << std::flush;

}
