###############################################################################
# OpenVAS Vulnerability Test
# $Id: asterisk_38424.nasl 7671 2010-05-12 17:34:03Z mime $
#
# Asterisk CIDR Notation in Access Rule Remote Security Bypass Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100513);
 script_bugtraq_id(38424);
 script_tag(name:"cvss_base", value:"4.3");
 script_cve_id("CVE-2010-1224");
 script_version ("1.0-$Revision: 7671 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Asterisk CIDR Notation in Access Rule Remote Security Bypass Vulnerability");

desc = "Overview:
Asterisk is prone to a security-bypass vulnerability.

Attackers can exploit this issue to bypass access control list (ACL)
rules, which may lead to other attacks.

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/38424
http://www.asterisk.org/
http://downloads.asterisk.org/pub/security/AST-2010-003.html

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if the installed Asterisk version is vulnerable");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("secpod_asterisk_detect.nasl");
 script_require_keys("Services/udp/sip");
 exit(0);
}

include("version_func.inc");

asterisk_port = get_kb_item("Services/udp/sip");
if(!asterisk_port)exit(0);
if(!get_udp_port_state(asterisk_port))exit(0);

asteriskVer = get_kb_item("Asterisk-PBX/Ver");
if(!asteriskVer){
  exit(0);
}

if(version_in_range(version:asteriskVer, test_version:"1.6.1", test_version2:"1.6.1.16") ||
   version_in_range(version:asteriskVer, test_version:"1.6.0", test_version2:"1.6.0.24") ||
   version_in_range(version:asteriskVer, test_version:"1.6.2", test_version2:"1.6.2.4")) {
     security_warning(port:asterisk_port, proto:"udp");
     exit(0);
}

exit(0);
