# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 374-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53696);
 script_cve_id("CVE-2003-0686");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 374-1 (libpam-smb)";
 script_name(name);

 desc = "The remote host is missing an update to libpam-smb
announced via advisory DSA 374-1.

libpam-smb is a PAM authentication module which makes it possible to
authenticate users against a password database managed by Samba or a
Microsoft Windows server.  If a long password is supplied, this can
cause a buffer overflow which could be exploited to execute arbitrary
code with the privileges of the process which invokes PAM services.

For the stable distribution (woody) this problem has been fixed in
version 1.1.6-1.1woody1.

For the unstable distribution (sid) does not contain a libpam-smb
package.

We recommend that you update your libpam-smb package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20374-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 374-1 (libpam-smb)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpam-smb", ver:"1.1.6-1.1woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
