###############################################################################
# OpenVAS Vulnerability Test
# $Id: echo.nasl 8100 2010-06-21 13:38:19Z mime $
#
# Check for echo Service 
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
 script_id(100075);
 script_version ("1.0");
 script_tag(name:"cvss_base", value:"0.0");
 script_tag(name:"risk_factor", value:"None");
 script_cve_id("CVE-1999-0635");

 name = "Check for echo Service";
 script_name(name);
 
 desc = "
  Overview:
   
   Echo Service is running at this Host.

   The echo service is an Internet protocol defined in RFC 862. It was
   originally proposed for testing and measurement of round-trip times in IP
   networks. While still available on most UNIX-like operating systems, testing
   and measurement is now performed with the Internet Control Message Protocol
   (ICMP), using the applications ping and traceroute.

  Solution:
   Disable echo Service.

  Risk factor : Low";

 script_description(desc);
 summary = "Check for echo Service";
 script_summary(summary);
 script_category(ACT_GATHER_INFO);
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 family = "Useless services";
 script_family(family);
 script_dependencies("find_service.nes");
 script_require_ports("Services/echo", 7);
 exit(0);
}

include("misc_func.inc");


port = get_kb_item("Services/echo");

if(!port)port = 7;

echo_string = string("OpenVAS-Echo-Test");

if(get_port_state(port)) {

  soc = open_sock_tcp(port);
  if(soc) {
  
    send(socket:soc, data:echo_string);
    buf = recv(socket:soc, length:4096);
    close(soc);
    if( buf == NULL ) exit(0);
  
    if(buf == echo_string) {
      register_service(port:port, proto:"echo");
      security_note(port:port, protocol:"tcp"); 
    } 
  }
}

if(get_udp_port_state(port)) {

  soc = open_sock_udp(port);
  if(soc) {

   send(socket:soc, data:echo_string);
   buf = recv(socket:soc, length:4096);
   close(soc);
   if(buf == echo_string) { 
     security_note(port:port, protocol:"udp");
   }
  }
}

exit(0);
