# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-11919 (bugzilla)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66323);
 script_cve_id("CVE-2009-3386");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Fedora Core 12 FEDORA-2009-11919 (bugzilla)");

 desc = "The remote host is missing an update to bugzilla
announced via advisory FEDORA-2009-11919.

Update Information:

Bugzilla 3.4.4 fixes security issues that were found in previous
versions of the software where private information would be leaked
to other users.

CVE Number:  CVE-2009-3386

See upstream security advisory for additional details:
http://www.bugzilla.org/security/3.4.3/

ChangeLog:

* Thu Nov 19 2009 Emmanuel Seyman  - 3.4.4-1
- Update to 3.4.4 (CVE-2009-3386)

References:

[ 1 ] Bug #539598 - CVE-2009-3386 bugzilla hidden bug alias disclosure
https://bugzilla.redhat.com/show_bug.cgi?id=539598

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update bugzilla' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-11919

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 12 FEDORA-2009-11919 (bugzilla)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"bugzilla", rpm:"bugzilla~3.4.4~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bugzilla-contrib", rpm:"bugzilla-contrib~3.4.4~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bugzilla-doc", rpm:"bugzilla-doc~3.4.4~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bugzilla-doc-build", rpm:"bugzilla-doc-build~3.4.4~1.fc12", rls:"FC12")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
