# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3768 (maniadrive)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64099);
 script_cve_id("CVE-2008-5557", "CVE-2008-5658", "CVE-2008-3658", "CVE-2008-5498", "CVE-2008-5814", "CVE-2009-0754", "CVE-2009-1271", "CVE-2008-2829", "CVE-2008-3660");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Fedora Core 10 FEDORA-2009-3768 (maniadrive)";
 script_name(name);

 desc = "The remote host is missing an update to maniadrive
announced via advisory FEDORA-2009-3768.

Update Information:

Update to PHP 5.2.9

ChangeLog:

* Thu Apr 16 2009 Remi Collet  - 1.2-13
- Rebuild for php 5.2.9

References:

[ 1 ] Bug #478425 - CVE-2008-5498 php: libgd imagerotate() array index error memory disclosure
https://bugzilla.redhat.com/show_bug.cgi?id=478425
[ 2 ] Bug #494530 - CVE-2009-1271 php: crash on malformed input in json_decode()
https://bugzilla.redhat.com/show_bug.cgi?id=494530
[ 3 ] Bug #459529 - CVE-2008-3658 php: buffer overflow in the imageloadfont function in gd extension
https://bugzilla.redhat.com/show_bug.cgi?id=459529
[ 4 ] Bug #459572 - CVE-2008-3660 php: FastCGI module DoS via multiple dots preceding the extension
https://bugzilla.redhat.com/show_bug.cgi?id=459572
[ 5 ] Bug #452808 - CVE-2008-2829 php: ext/imap legacy routine buffer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=452808
[ 6 ] Bug #474824 - CVE-2008-5658 php: ZipArchive::extractTo() Directory Traversal Vulnerability
https://bugzilla.redhat.com/show_bug.cgi?id=474824
[ 7 ] Bug #478848 - CVE-2008-5557 php: Heap-based buffer overflow in the mbstring extension via crafted string containing a HTML entity (arb code execution)
https://bugzilla.redhat.com/show_bug.cgi?id=478848
[ 8 ] Bug #479272 - CVE-2009-0754 PHP mbstring.func_overload web server denial of service
https://bugzilla.redhat.com/show_bug.cgi?id=479272

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update maniadrive' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3768

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-3768 (maniadrive)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"maniadrive", rpm:"maniadrive~1.2~13.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"maniadrive-track-editor", rpm:"maniadrive-track-editor~1.2~13.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"raydium", rpm:"raydium~1.2~13.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"raydium-devel", rpm:"raydium-devel~1.2~13.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"maniadrive-debuginfo", rpm:"maniadrive-debuginfo~1.2~13.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
