###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_dotproject_detect.nasl 1935 06-05-2009 13:52:24Z may $
#
# dotProject Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800564);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("dotProject Version Detection");
  desc = "
  Overview: This script detects the installed version of dotProject and
  sets the version in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets the KB for the version of dotProject");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

wwwPort = get_http_port(default:80);
if(!wwwPort){
  exit(0);
}

foreach dir (make_list("/dotproject", "/dotProject", "/Dotproject", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:wwwPort);
  rcvRes = http_send_recv(port:wwwPort, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if("dotProject" >< rcvRes)
  {
    version = eregmatch(pattern:"Version ([0-9.]+)(rc[0-9])?", string:rcvRes);
    if(version[1] != NULL)
    {
      if(version[2] != NULL){
        dotVer = version[1] + "." + version[2];
      }
      else
        dotVer = version[1];

      set_kb_item(name:"www/" + wwwPort + "/dotProject", value:dotVer + " under " + dir);
      security_note(data:"Dot Project version " + dotVer + " running at location "
                         + dir + " was detected on the host");
    }
    exit(0);
  }
}
