###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_robo_ftp_client_bof_vuln.nasl 5968 2009-12-01 14:50:29Z dec $
#
# Robo-FTP Response Processing Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801054);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_bugtraq_id(37143);
  script_cve_id("CVE-2009-4103");
  script_name("Robo-FTP Response Processing Buffer Overflow Vulnerability");
  desc = "
  Overview: This host has installed Robo-FTP and is prone to  Buffer Overflow
  Vulnerability.

  Vulnerability Insight:
  The flaw is due to a boundary error when processing certain responses from
  the FTP server. This can be exploited to overflow a global buffer by tricking
  a user into connecting to a malicious FTP server.

  Impact:
  Successful exploitation will let the user execute arbitrary code in the context
  of the vulnerable application. Failed exploit attempts will likely result in a
  denial-of-service condition.

  Affected Software/OS:
  Robo-FTP Client version 3.6.17 and prior.

  Fix:
  No solution or patch is available as on 01st December 2009. Information
  regarding this issue will be updated once the solution details are available.
  http://www.robo-ftp.com/download/

  References:
  http://secunia.com/advisories/37452
  http://en.securitylab.ru/nvd/388275.php

  CVSS Score:
    CVSS Base Score      : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 8.5
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Robo-FTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C)Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_robo_ftp_client_detect.nasl");
  script_require_keys("Robo/FTP/Ver");
  exit(0);
}


include("version_func.inc");

roboftpVer = get_kb_item("Robo/FTP/Ver");
if(roboftpVer != NULL)
{
  # Robo-FTP 3.6.17 (3.6.17.13)
  if(version_is_less_equal(version:roboftpVer, test_version:"3.6.17.13")){
   security_hole(0);
  }
}

