###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for xorg-server regression USN-571-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840328);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "USN", value: "571-2");
  script_cve_id("CVE-2007-5760", "CVE-2007-6427", "CVE-2007-6428", "CVE-2007-6429", "CVE-2007-5958", "CVE-2008-0006");
  script_name( "Ubuntu Update for xorg-server regression USN-571-2");
  desc = "

  Vulnerability Insight:

  USN-571-1 fixed vulnerabilities in X.org.  The upstream fixes were
  incomplete, and under certain situations, applications using the MIT-SHM
  extension (e.g. Java, wxWidgets) would crash with BadAlloc X errors.
  This update fixes the problem.
  
  We apologize for the inconvenience.
  
  Original advisory details:
  
  Multiple overflows were discovered in the XFree86-Misc, XInput-Misc,
  TOG-CUP, EVI, and MIT-SHM extensions which did not correctly validate
  function arguments.  An authenticated attacker could send specially
  crafted requests and gain root privileges. (CVE-2007-5760, CVE-2007-6427,
  CVE-2007-6428, CVE-2007-6429)
  
  It was discovered that the X.org server did not use user privileges when
  attempting to open security policy files.  Local attackers could exploit
  this to probe for files in directories they would not normally be able
  to access.  (CVE-2007-5958)
  
  It was discovered that the PCF font handling code did not correctly
  validate the size of fonts.  An authenticated attacker could load a
  specially crafted font and gain additional privileges.  (CVE-2008-0006)

  Affected Software/OS:
  xorg-server regression on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-January/000659.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of xorg-server regression");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"xnest", ver:"1.2.0-3ubuntu8.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-core", ver:"1.2.0-3ubuntu8.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-dev", ver:"1.2.0-3ubuntu8.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xvfb", ver:"1.2.0-3ubuntu8.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xdmx-tools", ver:"1.2.0-3ubuntu8.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xdmx", ver:"1.2.0-3ubuntu8.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xephyr", ver:"1.2.0-3ubuntu8.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"xnest", ver:"1.0.2-0ubuntu10.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-core", ver:"1.0.2-0ubuntu10.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-dev", ver:"1.0.2-0ubuntu10.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xvfb", ver:"1.0.2-0ubuntu10.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xdmx-tools", ver:"1.0.2-0ubuntu10.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xdmx", ver:"1.0.2-0ubuntu10.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"xnest", ver:"1.1.1-0ubuntu12.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-core", ver:"1.1.1-0ubuntu12.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-dev", ver:"1.1.1-0ubuntu12.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xvfb", ver:"1.1.1-0ubuntu12.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xdmx-tools", ver:"1.1.1-0ubuntu12.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xdmx", ver:"1.1.1-0ubuntu12.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xephyr", ver:"1.1.1-0ubuntu12.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"xnest", ver:"1.3.0.0.dfsg-12ubuntu8.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xephyr", ver:"1.3.0.0.dfsg-12ubuntu8.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-core-dbg", ver:"1.3.0.0.dfsg-12ubuntu8.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-core", ver:"1.3.0.0.dfsg-12ubuntu8.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-dev", ver:"1.3.0.0.dfsg-12ubuntu8.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xvfb", ver:"1.3.0.0.dfsg-12ubuntu8.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xdmx-tools", ver:"1.3.0.0.dfsg-12ubuntu8.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xdmx", ver:"1.3.0.0.dfsg-12ubuntu8.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xprint", ver:"1.3.0.0.dfsg-12ubuntu8.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xprint-common", ver:"1.3.0.0.dfsg-12ubuntu8.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}