# kst-gpl
#
# (C) David Lodge 13/08/2007
# This script is based on sybase_blank_password.nasl which is (C) Tenable Security
#
# This script is released under the GPLv2
#

desc = "
Synopsis :

The remote database server is affected by an information disclosure
vulnerability. 

Description :

The remote Sybase SQL Anywhere / Adaptive Server Anywhere database is
configured to listen for client connection broadcasts, which allows an
attacker to see the name and port that the Sybase SQL Anywhere /
Adaptive Server Anywhere server is running on. 

See also :

http://www.sybase.com/products/databasemanagement/sqlanywhere

Solution :

Switch off broadcast listening via the '-sb' switch when starting
Sybase. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";

if(description)
{
 script_id(80089);;
 script_version ("$Revision: 1.1 $");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Sybase ASA Ping";
 script_name(name);

 script_description(desc);
 
 summary = "Locate service enabled on Sybase server";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2007 David Lodge");
 family = "Databases";
 script_family(family);

 exit(0);
}

#
# The script code starts here
#
include("misc_func.inc");

port = 2638;
if (!get_udp_port_state(port)) exit(0);

req = raw_string(
   0x1b, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x00, 0x12,
   "CONNECTIONLESS_TDS",
   0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
   0x04, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x03, 0x01, 0x01,
   0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
);

soc = open_sock_udp(port);
if(soc)
{
   send(socket:soc, data:req);
   r  = recv(socket:soc, length:4096);
   close(soc);
   if(!r)exit(0);
 
   name="";
   length=ord(r[0x27]);
   for (i=0x28;i<0x27+length;i++)
   {
      name+=r[i];
   }

   offset=0x27+length+3;
   serverport=ord(r[offset])*256+ord(r[offset+1]);

   report = desc +
      string("\n\nPlugin output :\n\n") +
      "Database name: " + name + string("\n") +
      "Database port: " + serverport;

   security_warning(port:port, protocol:"udp", data:report);
}
