# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

# Embedded icon is designed by Igor Kekeljevic (http://www.admiror-ns.co.yu).

# Follows PEP8

from core import models
from lib.reverse_translation import _t

#--- PIL function


def init():
    #lazy import
    global Image, ImageOps, imtools
    import Image
    import ImageOps
    from lib import imtools


def grayscale(image, amount=100):
    grayscaled = ImageOps.grayscale(image)
    if amount < 100:
        grayscaled = imtools.blend(image, grayscaled, amount / 100.0)
    if image.mode == 'RGBA':
        grayscaled.putalpha(imtools.get_alpha(image))
    return grayscaled

#--- Phatch Action


class Action(models.Action):
    label = _t('Desaturate')
    author = 'Stani'
    email = 'spe.stani.be@gmail.com'
    init = staticmethod(init)
    pil = staticmethod(grayscale)
    version = '0.1'
    tags = [_t('color')]
    __doc__ = _t('Fade all colors to gray')

    def interface(self, fields):
        fields[_t('Amount')] = self.SliderField(100, 1, 100)

    icon = \
'x\xda\x01\xfa\x0c\x05\xf3\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\
\x00\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\
\x08\x08|\x08d\x88\x00\x00\x0c\xb1IDATh\x81\xd5\x99k\x8c]\xd5u\xc7\x7f{\x9f\
\xd7\xbdw\x9e\x1e\xb0\x1d\xd7\x10\xe4\x07\x81:<\x8c\x1a\x0c\xa4\x06\x99\xa4\
\xa1@\xda\xa2VXP\xa9\xc9\x07\x10\xa8\x02"Z\xaaP\xa5RDQ\x1b QU\xf1\x05C\x88#+\
Bq\x04y\x88\x84G"0\x01\x81\x8d\x07;\xb1\x8d\xc3\x18\x1b\x860.&~\xcc\xe3\xce\
\xdc\x99;\xe7\xb9\xf7\xea\x87s\xce\xcc\x9d\xf1\x98\xc4x\xdc*{\xb4t\xe6\x9e{t\
\xce\xff\xbf\xd6\x7f\xad\xb3\xd6\xbeJD\xf8c^\xfa\xff\x1b\xc0\xa9\xae?z\x02\
\xee\xe9\xba\xf1\xaf\xbf\xf2\x95\x0b\x95\xeb.\x940\xec\xfd\xb3\xc7\x1e\x9b<]\
\xcfQ\xf3\x95\x03\xbdw\xdcq]\xb6t\xe9\xbfg\xcb\x97\xaf\x96\x9e\x1e_W*\xf9\
\x17YF\xb0}\xfb/\xae\xf8\xfa\xd7\xaf\x97\xd3\x90p\xa7L`\xc7\x1dw\xac\x1f\xbf\
\xe0\x82\xefd+Vt)\xa5\xd0Z\xd3zTJ\x01\xe0\xf4\xf5\x1d\x96]\xbb.\xber\xe3\xc6\
\xc1\xf9\x00^\xae\x8fM`\xf7-\xb7t\xd7\x97-\xeb\x9d\xbc\xe8\xa2\xf3\x94\xeb\
\x1e\x07\xbc\xf5\xe88\x0eJ)dl\xc8x\xef\xbcx\xd7\x15\xf7l\xf8\xf6|E\xe3c\xe5\
\xc0\x8e\x9bo^\\\xbf\xec\xb2w\xc2e\xcb:\xb5R(k\x01\xa6\xbc\xad\xb5FkM\xa5\
\x12\xe0\xfb\x1e\x90\x7f\xa6\xad\xcd\xb1\x9f\xf8\xf2\xa3\xbb^\\t\xa5R\xea\
\x1f\xe6\x83\xc4IG`\xfbM7\xad\x1c\xff\xccgv\x85K\x97v\x88\xef\x83\xeb\xce\
\xf0x\x10\x04\xb4\xb7UQ\xda\x9d!\xa3V\x03\xc1\x957v\xef\x7f\xef\xe5K\xd7\xaf\
\x7f\xca\xfc\x9f\x11\xd8}\xf3\xcd\x17\x1f\xfd\xf4\xa7\xb7%\x8b\x16\xb5\x89\
\xefC\x10`=\x0f\\\x17\xd7u\xe9ho\xc3\xf5\xfc9\x81\xcf>\x07\xa0l\xff\x18f\xdb\
\xa5\xab\xd7<\xfc\xeei\'\xb0\xe7\xc6\x1b?{\xf4S\x9fz1^\xb0\xa0F\x10\xd0J@\
\xd7jt\xf7t\xa1\xb4wB\xd0\xd6Z\xa2t\x820\x8b\x05\xabp\xc4U\x820n\x1a\xe6\xe5\
\xf0\x95;6\xfc\xed\x86\xc7O\x1b\x81_]sMW\xfd\xfc\xf3?H\xbb\xbb;\x8c\xe7!A\
\x80\xf5}$\x08\xd0]\xedt.9\x13G;\x08>0\x13x\x96\xa5\xd4\'G\x84X\xab27Z\x13\
\x1c \x95\x94\xad\xc9\xb6\xa7\x1e\xfa\x9b\x07o:-\x04\xb6\xdfx\xe33\xa3K\x97\
\xfeU\tZ\x82\x00\xe3y\xa8\x85]t\x9c\xb3\x98 \x10\xacxX\xeb#\x04(\xa5\x11\x11\
\xea\xcdA\xb2\x10\xb4\x9a\x06\xdc\n~\xf6\xe77\xe3\x03\x87vL\x1e\xba\xe0\xc9\
\xf5\x0f\x8e\xcd\x1b\x81\x1dW]\xf5\xb9\xd1\xe5\xcb_\xb4A\xa0\xa5R\xc1\xfa>\
\xd6\xf7\xe1\xac\x1e\xdaV.\xa2V\xcd\xb0\x92\x03\xb7\xe2a\x8cOf\x1c\x8e\xd4\
\x8f\xe2d\xee\t\x01W*\x15\xaa\xb5\x1aA\xb5\x8a\xe78\xa8\xe2y\x87\x9b\x13\xf6\
\x99\xe4\xc8\r\x8f~n\xfd\xb3\x7f\x08\x81\x8f\xee\x85\x94RqG\xc7F\x1d\xc7\x9a\
8\x86(\xca-\xb0\xb4\x9f[\x91\x8e\xb6!\xb4\x8ePD@\x08\x12\x93\xa4!\x03\x83\
\x07I\x93\x0cc\x0c\xc6\x18\xac\xb5S\xe6\xfb>=\x0b\x17\xd2\xdd\xddM%\x08\xd0"\
\x88\xb5\x94\x8e\\\xd2\xd6\xae\xff\xbe{\xe5\xcf\xee\xdb\xf5\x9b{O\x99\xc0\
\xaf/\xbf\xfc?RXF\x1c\xe3\xc41:\x8aPq\x8c\x7f~\xbb\xed\xac\r)E\x84"F\xa9\x08\
ML3\tyg\xe4w\x12JDJJ"\xc9\x14\t\xad5]g\xf4\xd0\xd5\xd5\x85\x03\x88\xc8\x94\
\xb5\x12\x04\xe8P\xa8\xbfV\xd97\xff{\xd7o~\xfe\xfb\x08\x9cPBo]x\xe1\xd9\xa3]\
]\xfb\xb3J\xa5f}\x1f\x1b\x04\x18\xdf\xc7\\t&g^\xd5\x8e\xe7)\xacT\xb0\xd6\xc7\
J\xc0P\x14\xf0\xd6P\x13\x8b\xc5\x13\x0f\xdf\xfaS\xc7\xaa[e\xc1\x92%\xb8\xae\
\x87\xaf\x15n\x1e\xdc\x19\xd5\xca\x1aC\x92d$\xb1\x15\x85U\x0e\x19\x82\xe2\
\x9dC\xb6\xb1s[e\xe5\xc6\xef^5g\x0br\xc2\x08\xa4\xc6\xdc\xa3\xe2\xb8\xa6\xe3\
\x18U\xc8G9\x19\xb5K\x1c[\tFQL\xa2\x08Q*b,\x89yc\xf8\x18\r\xdd &&U)\x89N\x88\
U\x0c\xbeCe\xd1bB/ V\x8aD -\xbc."$Q\xc4\xe0\x91:c\x83\x83\xc4\xe3c\x905\x95\
\xb21\x88Ea9\xef,:\xbf\xf0\xf9\xf8\xc3\xbb\xfe\xf5\xf5\xebO\x8a\x00\xc6|^\'\
\t:\x8a\xd0q\x8c\x8ec\xd4\x15\x15\xb3`\xc11\xad\x08\xc9\xe5\x13\xa2UD\xef\
\xc8\xb8\xa9;\xa3D*&Q\t\x11\x1111\xda\xa9\xe1\x9dq6\xe3\x95\x1a\x11Bl\x85\
\x08\x88\x05\xe24e\xf0h\x9d\xc6\xf00\xcaL\xce\x90\x91-\xf2\xa6T\xc7\xe23\xc5\
\xfb\xe2\xda\x89g\xbfv\xff\xd6\x87\xff \t\xbd\xbdp\xe1\x92\xb0\xbd\xfdP\xea\
\xfb\xda\x06\x01\x99\xef\x93\x9e\xdfN\xc7m\x9d\xd4\xaa\x16\x91*B\x15+\x01\
\xbbG\xdb\xe4\xd5\xe6\xb8rq\xf1\xc5\xc7\xb7\xb9u\xeb\xb3\xe9\xe8>\x0fS\xad\
\x11\x00>\x82/\x16\x1f\xf0\xa2\x84\xe8\xd80\x81\x93\xa1\x1d\x07\xadT~\xd4\
\x1a\xa5u\xfeYk\x8ch\x8e\x8d8Q3\xd4\xcd0q\xc6*\xbe\xb4\x1d<\x12l~\xe8\xbe?\
\xbf\xa7\xc4:g3\xa7\xb2\xecF\x15E\xda)\xc8ikq\xd7T\xa3\x8e\xdaPE\xa4\x8a\x05\
\xac\xb5L\x18\xe1\x95f"\xa1\x8aU >\xb6\xf8\xf3\x9d3\x91\xeeU\x8cT\x02*\xe4\t\
kE\x10\xa5\x90\x89\x88\xc9##\xb8\xda\x92\n8\x92\xe1h\x8d\x14\xd7i\x11\x0e\
\x1eu\xe3}\xefE;\xb7o}\xee\x1b;{7\xed\x05&\x80\x18\xc8\x00\xfb\xd0}\xd3N?\
\x8e\x80RJ\xf5\xd5j_t\x94B\x00+\x82\xa3\x85`\xd5\x84\x8b\x08\x8a\xd2,O\x0f;\
\xe9Qw\xdc\x0b$@\xac \x00Z\xa3j\x17\xdaz\xb5M\x07b\x01\xc9\t+A\x8d\x84\xa4\
\x87GQ\x80\xf54F\x04\xcf\x82\xe7Z\xb4\x08\xf5q\xdf\xfe\xfc\x97\xefm\xfd\xf1\
\x93_\xfd\x1e0\x08\x8c\x025 -\xc0\x9b\x02"e\'\xeb\xce\x06\xffC\xa8\xe88\xbeR\
\x8b\xe0\x88\x80\x08\xd9\x9f*\xda;\x12W+\x1fcs\x02}\x91\x967\xe4\xa8\xa7Da\
\x11,\x82 \xb4\xbb\x97J\xbdc\xb1\xf6\x04,\n#\x82\x11p\x8e\x85L~8\x0e\xe2\xe2\
\xb9\x06+\x82\xe7:\x88#X1\xec|+\x1d||\xc3\x9d\x1b\xc3\xb0>B\x9e\x9b.\xe0\x15\
\xe6\x02Nq\xde\xb6bv[\xc1\x03j%\xac\xc3\x98\x9aN\x12\xca@%\xabm\xe4\xb9\xa6b\
m\x15\xad@\x80\xcd\xc3\x92\x8ey\xb1_Q\x15\x90<\xfc\x8e>\x83\xb0\xe3\x12\xac\
\xd6\x04e\x9dG\xe1\x0e\x86\x84\xfd\x93\x08\x1e\xbek\xf3\xc8Z\x8b\x88\xc5\x1a\
\xcb\xcb\xbb\x9a\x03\xdf\xdbx\xdb&\xa0\t\x8c\x176Y\xc8\xc6\xcc\x06=\'\x81b\
\xe9\x14\x16\xf8\x806\x06)H\xf8\x97\xa7Jl.\x07\x850f,\xfb\xfd\xc8S\xe8B:\x82\
\xc5\xd2\xe6}!\xabW\xda\xdc\x00ATquj\x08\x0eL\xda8\xf6\xb4\xe7XD\x14\xd6*\
\x8c\xab\xb1\xa2\xd8\xba\xf3\xe8[?\xd9|\xd7\xf7\x81\xc6,\x9bh!\x92\x9e\x88\
\x88\xdb\xe2}\r\xb8\xe3P\xad\x92{Y\x1b\x03Kb\xdc\x85:\xb0F\xa1t\x08X^\x0b\
\xc5\x8c*\xebT$@T~O\xcf\xbdL\xc6\xba\xces]\xc0\nE\xfe@\xb5o\xc2\x8e\x8dz\xda\
u\x04\xeb\xa9\xa2\x00@fE\xb6\xf4\xbe\xd3\xfb\xe2\xcf\xbe\xfaCr\xad\x97\xd6("\
\x11B^u\x81\x84<\x07\x8a\\\x9f.\x9de\x04J\x02\xde$\xb4\xd9\xe2\x84\x00\xd9%6\
\x0b\xb0\xae\xb5\x1a%\x82\xd2\xc2\xd3C$Q\x85\xaa\xa8\xa2\xba \xf8\xfe5i\xea8\
~\x85\\6b\r\xcep\xc6\xe4{(p\xf0\xad\xe4\x92\xb1\x90i\xe4\xb5\xed;_\xe8}\xe9\
\xfeg\x81\x11`\x18\xa8\xb7\x80\x8fZ@g\x85\xe7K\x9b\x19\x81R\xfb\xe4I\xe2OB\
\xad$\xa0\x80F\x95\xb0\xc7\xd2\xa1\x94E+!\x15a\x97\x8e}1\x0e\xa2s\xe9\xa0{\
\xd0\x1d\x9f\xf4}\x95\x03\xb7"X\x14\xed[\xc7\xb3\xf1f\xe0z\xae\xc5\xbay2[+\
\xbc\xff?\xc3\xfb{_\xba\xff\xe9\x02\xf8PAb\xac\x00\x1f\xcf\x92\x8c\xcc\xe5\
\xf9\xb9"\xe0\x00\xfek\xf0\xee\xd9K\x97\x8e\xaa\xbb\xef\xeeV\x95\n\xea\x13T\
\x9b\xda\xa0\x8a{\x8dd\xc2\xe6\xf3\xceu~0\xfa$?\x1d\xfa)\xa2\x04m\xd7$J;\xbe\
A\x10\xa5\xb1X*\xbb&\xed\xd8\xe1\xaa\xeb\xb9\x85\xa4\xc4b\xd1LN\xda\xf0\xa5g\
\xfe\xe51\xe0\x18y\xa9\x1c.\xc0\x97I[\x96\xcb\x128\x1f5\xfc\x1f\'\xa1\xda\
\xbd\xf7.N\xae\xbb\xce\xf5|\x1frVn9u+\xa5\xb8h\xd99,Y\xb2\x84\xb5\x13ky~\xcb\
\xf3\xa46!\n\xae\xcaP\xda\x17\xb1\x88RXQ\xb4\xbd\x9eH\x96U\xc8\xac\xc5\x1a\
\xc1\xfa\x0e\xc6\x1a\xfa\xf6\xbe\xf2\xa38\x1c\xfa\xb0 0D\xae\xfb\xd9\x15gNo\
\xcf\xb5\x9cV\xf0\x9b7o\xbem\xcd\x9a5\xdfr\\\xb72\xfbB\xdf\xf7Y\xb5j\x15===\
\x18cp\x95\xcb\ng9?9\xf6\x0bd\xe1\xd7\x1c\xeb8\xf9L"\xe0\xfe\xce\xa2z\x95\
\xb6\x85\x10\xcb\xb6\xb9^\x1f\xfd\xed\xaf~y\xd7\xb7g\x81/e3UeNf\xbbe\xaa\x8c\
\xae_\xbf\xbe;I\x92;\xdf~\xfbm\xa7\x9cU[7\xa6V\xacXA\xb5Z%MS\xac\xb5\x18c\
\xb8n\xc9u\xac9\xf4e\xb3\x03\xed`-\x93Ja\xb5\xc6\xef\x9dH\x9aq\xc5\xf7\x8bZ/\
\xaeKj\xd2d\xcf\xeb\x0f>B\xae\xf7\xd9\x9a7\x80\xfd8\xfbDS\x11\xd8\xb7o\x9f}\
\xf5\xd5W\x7f\xb4n\xdd\xbaui\x9a.\x9e\xd1\x1dZ\xcb\xd0\xd0\x10\x8b\x16-"\x08\
\x82\x19\x93\xd6\xba\xf6\xd5\xea\xd1\xb1D\x95\x8f6(\xbc\x1f\x84\xa9\x84\x9e\
\x8bR\x88\x80E\x18>\xb2\xf7\x85\xc3\xef~gK\xe1\xfd\x11\xa6\xfb\x9b\x8f\r~\
\x06\x01\xc0\x0b\xc30x\xee\xb9\xe7^\xbb\xfa\xea\xab\xafq\x1c\xa7\xb3\xbc\xa8\
\xbc\xf7\xd0\xd0\x10\xe7\x9cs\xce\x14\x01c\x0c\x15\xed\xa8\x9e,aKd\x10\x01F\
\x04\x9eq\xa7\xc0# \x16;\xb0\xe7\xdf\x1e6\xc9\xd0\x87\xe4\xd2i\x90\xd7\xf9\
\xf4T\xc0\xc3\xccy@(j\xed\xc4\xc4\xc4\xb81\x86,\xcb\xc8\xb2\xe9\xd9\xb6^\xaf\
\xd3\xd7\xd7G\x96e\xa4i:\xf5\xfdM\x9d\x15V:`\xc5b\xb6\x85i\x948\x84\xb1"\x8a\
\x15Q\xac\x19\x1fo|\x18O\xec?\xcc\xcc\x16!\xe3$\x92\xf5\xf7\x11\x98\x02\x0f\
\x18c\x8c\xb4\x02/-\xcb2\xf6\xed\xdbG\xbd^\x9f\x02\x9fe\x19\xd6\x18\x1eiW`-\
\xf6\xf5\x89$M\x850R\x84\xb1&\x8c`\xa21\xb0\x9b\\2\xe5K*e\xba\xc6\x9f\xd2\
\x9a\x1d\x01\x03\xa4\xd6Z\x99\r\xbc$\x94\xa6)\xbbw\xef>.\n\x7f\xe2(n\xf7,\
\x8c\xe6I\x9ee9\x89(q\x988\xf2\xf4\xcbL\xb7\x07I\xf1\x9cS\xf6~+\x812\x02\x19\
\x90\x88\x88\x9dKB\xe5\xb9\xc1\xc1A\xde\x7f\xff\xfd\x19Q\xc8\xb2\x8c[\x02\
\xe1\x8cN\xa5\xc0 b1\xc6\x12F\xe3G\xd3\xb1\xe7\xfb\xc9\xa53\xaf\xde\x9f\x8b@\
J\xee%s"\t\x95\xff\xef\xdf\xbf\x9ff\xb39#\n\x18\xc3\xc3w\xd7*-j\xc4\xc6\x03o\
\x16\xe0\xcb\xa4\xfd\xc8\xf6\xf8\xa4\t\x14al%0y\xe4\xc8\x91\xef[k\xa3\xb2\
\xde\xcf\x15\x898\x8ey\xf3\xcd7\x8f\x8b\xc2\'\x17[}\xfd\x95)H\xd1\r$\xbf\xdd\
W\x80/{\x9c\x93~Y}$\x81\x96\xff\xa7"\xb0i\xd3\xa6\xa7\xb6n\xdd\xfa\xa5$I\x0e\
\x95\x1bOs\xe5D\xbd^\xe7\x83\x0f>\x98\x11\x854\xcd\xf0\xbd"\x02b@\x99\xd6\
\x929\xa3\xc7\x997\x02\x857l\xf1\x80\x18\x18\xdf\xb2e\xcb\x8e\'\x9ex\xe2\xa6\
F\xa3\xb1\xb5\xb8\xe68\x19\xed\xdd\xbb\x97\x9d;w\x12E\x11i\x9a200`\x1fx\xe0\
\x9b\x0f?\xfd\xfc\x81\xd7\xa6dd\xa5\xc1\xb4\xf6K\x02\xf3\xb6\xa6\xb6UZ\xdajM\
>\x87\x06@;\xd0u\xfb\xed\xb7\xdfu\xd6Yg\xddNK\xc4\xb4\xd6\xf4\xf7\xf7\xb3g\
\xcf\x1e\xd6\xae]\x0b\xc0\xe3\x8f?\xfeV\x92$\x0f\x001\x8b\x1e\xba\x92\xcag\
\xff\x91\xc9\x17\xeed\xe8?_b\xba\xe3\xccDd\xder`\xc6\xbe\xd0,\x12nA\xa2\x06t\
\xdep\xc3\r\x7fq\xf1\xc5\x17\x7f\xc3u\xdd\xae\xf2\xfaF\xa3!\x07\x0e\x1cP\x03\
\x03\x03\x1c<x\x90F\xa3\xf1\x14\xb0\x81r\x18Y\xf0\xcf\xcb\x91\xd1\xc3\x8cn:@\
K\xeb0\x9f?\xb7\x1e\xb7\xb1\xa5\xca\xdf\x7f\xa6I\xf8@\x15\xe8\\\xbdz\xf5\xb9\
\xd7^{\xed\x7f\xd5j\xb5U\x00\xcdf3\x0c\xc3\xb0z\xf0\xe0A\xd3\xd7\xd7\xf7X\
\x7f\x7f\x7f9\x98\x97\xc9ZJ2*,\xe3\x14[\x87\xd9\xeb\xb8\xadE)\x16\xd3\xef\
\x85\xb8\x005\xbag\xcf\x9e}\x8f<\xf2\xc8\x97\x86\x87\x87\x7f\x0c`\xad\x1dw\
\x1c\xa7\xd1l6\xff\xa9\xbf\xbf\x7f\x03\xf9\x802B>\x1e\x8e1\xdd:\x94/\xafy\
\x93N\xb9>\xf2\x07\x8eY\xe3f\xab\xa4j\xb7\xdez\xeb\xdfuvv\xfe\xe5\xb6m\xdb\
\xbe\xb5c\xc7\x8ew\x99Y\xeb[\x81\x96o\xf8\x93\x1aT\xe6\x85\xc0,\x12\xba \xe2\
3\xbd\xe1\xa4\x0bp)\xd3C\xf8\\\x95\xe6\x843\xed\xa9\xae\xff\x05\xa2\x80I\x98\
\x91\xa4\x13\xca\x00\x00\x00\x00IEND\xaeB`\x82_*x\xaf'
