//----------------------------------------------------------------------------------------
// Name:        Doxygen_includes.h
// Purpose:     Doxygen commands that don't belong in the source code like the 
//              text on the main page, and groups.
// Author:      Robert O'Connor
// Modified by:
// Created:     2002/07/18
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: docs_doxygen_commands.h,v 1.5 2003/06/26 03:27:50 robertoconnor Exp $
//---------------------------------------------------------------------------------------- 

//---------------------------------------------------------------------------------------- 
// Contents of the main page
//---------------------------------------------------------------------------------------- 

/*! \mainpage Plucker Desktop Source
    <hr>
    <h3>Building instructions</h3>
    <ul> 
        <li><a href="docs_building_linux_gtk.html">Build for Linux/GTK</a>
        <li><a href="docs_building_macintosh_osx_apple_free_tools.html">Build for Macintosh OSX (Free Apple Tools)</a>
        <li><a href="docs_building_msw_borland.html">Build for MSW/Borland</a>
        <li><a href="docs_building_msw_borland.html">Build for MSW/Borland</a>        
        <li><a href="BUILDING_MSW_MS_VISUALC.htm">Build for MSW/MS Visual C++</a>
        <li><a href="docs_building_other_platforms.html">Build for other platforms/compilers</a>
        <li><a href="docs_building_removable_wxwindows_items.html">Items you can remove from wxWindows library</a>
     </ul>
    <hr>
    <h3>An introduction to the sourcecode</h3>
    <ul>
        <li><a href="docs_overview.html">One page summary overview of program</a>
        <li><a href="docs_breakdown_h.html">Breakdown of a header (.h) files</a>
        <li><a href="docs_breakdown_cpp.html">Breakdown of a source (.cpp) file</a>
        <li><a href="docs_coding_guidelines.html">Sourcecode formatting guidelines</a>
    </ul>
    <hr>
    <h3>Specific source code documentation</h3>
    <ul>     
        <li><a href="hierarchy.html">Class hierarchy</a>
        <li><a href="classes.html">Alphabetical class index</a>
        <li><a href="annotated.html">Compound index</a>
        <li><a href="files.html">File list</a>
        <li><a href="functions.html">Compound members</a>
        <li><a href="globals.html">File members</a>
        <li><a href="modules.html">Defines</a>
    </ul>
    <hr>
    <h3>Changelog, TODO and test lists</h3>
    <ul>
        <li><a href="docs_plucker_desktop_changelog.html">Plucker Desktop changelog</a>
        <li><a href="todo.html">TODO items generated by the source code</a>
        <li><a href="docs_todo.html">Other TODO items</a>
        <li><a href="test.html">Items to be tested</a>
    </ul>
 */ 
 
//---------------------------------------------------------------------------------------- 
// Doxygen 'Group' definitions
//---------------------------------------------------------------------------------------- 

/*! \defgroup defines Defines
    There are 5 types of defines: \e plkr prefixed, \e setup prefixed, the wxWindows 
    defines and macros, the _*H_ defines at the tops of headers that just serve to 
    exlude a header, and any private defines inside a .cpp not a .h that we don't care 
    about,  
    \brief Defines of the application. 
 */
 
 /*! \defgroup plkr_defines Defines: plkr* prefixed
     \ingroup defines
     \brief These defines can be found in plucker_defines.h .
  */

 /*! \defgroup setup_defines Defines: setup* prefixed
     \ingroup defines
     \brief These defines can be found in setup.h .
  */  
  
 /*! \defgroup wxwindows_macros Defines: wxWindows macros
     \ingroup defines
     Many, but not all, begin with a wx or WX prefix.
     \brief These macros can be found in the wxWindows libary headers.     
  */  

