/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;

public class MethodInvocationFixer
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
    private Clazz referencedClass;
    private Clazz referencedMethodClass;
    private Member referencedMethod;

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        int n2 = constantInstruction.constantIndex;
        this.referencedMethod = null;
        clazz.constantPoolEntryAccept(n2, this);
        if (this.referencedClass != null && this.referencedMethod != null) {
            byte by = constantInstruction.opcode;
            if ((this.referencedMethod.getAccessFlags() & 8) != 0) {
                if (by != -72) {
                    Instruction instruction = new ConstantInstruction(-72, n2).shrink();
                    this.codeAttributeEditor.replaceInstruction(n, instruction);
                }
            } else if ((this.referencedMethod.getAccessFlags() & 2) != 0 || this.referencedMethod.getName(this.referencedMethodClass).equals("<init>")) {
                if (by != -73) {
                    Instruction instruction = new ConstantInstruction(-73, n2).shrink();
                    this.codeAttributeEditor.replaceInstruction(n, instruction);
                }
            } else if ((this.referencedClass.getAccessFlags() & 0x200) != 0) {
                int n3 = ClassUtil.internalMethodParameterSize(this.referencedMethod.getDescriptor(this.referencedMethodClass), false) << 8;
                if (by != -71 || constantInstruction.constant != n3) {
                    Instruction instruction = new ConstantInstruction(-71, n2, n3).shrink();
                    this.codeAttributeEditor.replaceInstruction(n, instruction);
                }
            } else if (by != -74 && (by != -73 || clazz.equals(this.referencedClass) || !clazz.extends_(this.referencedClass))) {
                Instruction instruction = new ConstantInstruction(-74, n2).shrink();
                this.codeAttributeEditor.replaceInstruction(n, instruction);
            }
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        if (ClassUtil.isInternalArrayType(refConstant.getClassName(clazz))) {
            this.referencedClass = refConstant.referencedClass;
        } else {
            clazz.constantPoolEntryAccept(refConstant.u2classIndex, this);
        }
        this.referencedMethodClass = refConstant.referencedClass;
        this.referencedMethod = refConstant.referencedMember;
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.referencedClass = classConstant.referencedClass;
    }

    private void debug(Clazz clazz, Method method, int n, ConstantInstruction constantInstruction, Instruction instruction) {
        System.out.println("MethodInvocationFixer:");
        System.out.println("  Class       = " + clazz.getName());
        System.out.println("  Method      = " + method.getName(clazz) + method.getDescriptor(clazz));
        System.out.println("  Instruction = " + constantInstruction.toString(n));
        System.out.println("  -> Class    = " + this.referencedClass);
        System.out.println("     Method   = " + this.referencedMethod);
        if ((this.referencedClass.getAccessFlags() & 0x200) != 0) {
            System.out.println("     Parameter size   = " + ClassUtil.internalMethodParameterSize(this.referencedMethod.getDescriptor(this.referencedMethodClass), false));
        }
        System.out.println("  Replacement instruction = " + instruction.toString(n));
    }
}

