# -*- coding: utf-8 -*-
#  Licensed to Elasticsearch B.V. under one or more contributor
#  license agreements. See the NOTICE file distributed with
#  this work for additional information regarding copyright
#  ownership. Elasticsearch B.V. licenses this file to you under
#  the Apache License, Version 2.0 (the "License"); you may
#  not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
# 	http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing,
#  software distributed under the License is distributed on an
#  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
#  KIND, either express or implied.  See the License for the
#  specific language governing permissions and limitations
#  under the License.

from __future__ import unicode_literals

import logging
from typing import (
    Any,
    Collection,
    Dict,
    List,
    Mapping,
    MutableMapping,
    Optional,
    Sequence,
    Tuple,
    Type,
    Union,
)

from typing_extensions import Literal

from ..transport import Transport
from .async_search import AsyncSearchClient
from .autoscaling import AutoscalingClient
from .cat import CatClient
from .ccr import CcrClient
from .cluster import ClusterClient
from .dangling_indices import DanglingIndicesClient
from .enrich import EnrichClient
from .eql import EqlClient
from .features import FeaturesClient
from .graph import GraphClient
from .ilm import IlmClient
from .indices import IndicesClient
from .ingest import IngestClient
from .license import LicenseClient
from .logstash import LogstashClient
from .migration import MigrationClient
from .ml import MlClient
from .monitoring import MonitoringClient
from .nodes import NodesClient
from .remote import RemoteClient
from .rollup import RollupClient
from .searchable_snapshots import SearchableSnapshotsClient
from .security import SecurityClient
from .shutdown import ShutdownClient
from .slm import SlmClient
from .snapshot import SnapshotClient
from .sql import SqlClient
from .ssl import SslClient
from .tasks import TasksClient
from .text_structure import TextStructureClient
from .transform import TransformClient
from .watcher import WatcherClient
from .xpack import XPackClient

logger: logging.Logger

class Elasticsearch(object):
    transport: Transport

    async_search: AsyncSearchClient
    autoscaling: AutoscalingClient
    cat: CatClient
    ccr: CcrClient
    cluster: ClusterClient
    dangling_indices: DanglingIndicesClient
    enrich: EnrichClient
    eql: EqlClient
    features: FeaturesClient
    graph: GraphClient
    ilm: IlmClient
    indices: IndicesClient
    ingest: IngestClient
    license: LicenseClient
    logstash: LogstashClient
    migration: MigrationClient
    ml: MlClient
    monitoring: MonitoringClient
    nodes: NodesClient
    remote: RemoteClient
    rollup: RollupClient
    searchable_snapshots: SearchableSnapshotsClient
    security: SecurityClient
    shutdown: ShutdownClient
    slm: SlmClient
    snapshot: SnapshotClient
    sql: SqlClient
    ssl: SslClient
    tasks: TasksClient
    text_structure: TextStructureClient
    transform: TransformClient
    watcher: WatcherClient
    xpack: XPackClient
    def __init__(
        self,
        hosts: Any = ...,
        transport_class: Type[Transport] = ...,
        **kwargs: Any,
    ) -> None: ...
    def __repr__(self) -> str: ...
    def __enter__(self) -> "Elasticsearch": ...
    def __exit__(self, *_: Any) -> None: ...
    def close(self) -> None: ...
    # AUTO-GENERATED-API-DEFINITIONS #
    def ping(
        self,
        *,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> bool: ...
    def info(
        self,
        *,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def create(
        self,
        *,
        index: str,
        id: str,
        document: Any,
        doc_type: Optional[str] = ...,
        pipeline: Optional[str] = ...,
        refresh: Optional[Union[Union[Literal["wait_for"], str], bool]] = ...,
        routing: Optional[str] = ...,
        timeout: Optional[Union[int, str]] = ...,
        version: Optional[int] = ...,
        version_type: Optional[
            Union[Literal["internal", "external", "external_gte", "force"], str]
        ] = ...,
        wait_for_active_shards: Optional[Union[Union[Literal["all"], str], int]] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def index(
        self,
        *,
        index: str,
        document: Any,
        doc_type: Optional[str] = ...,
        id: Optional[str] = ...,
        if_primary_term: Optional[int] = ...,
        if_seq_no: Optional[int] = ...,
        op_type: Optional[Union[Literal["index", "create"], str]] = ...,
        pipeline: Optional[str] = ...,
        refresh: Optional[Union[Union[Literal["wait_for"], str], bool]] = ...,
        require_alias: Optional[bool] = ...,
        routing: Optional[str] = ...,
        timeout: Optional[Union[int, str]] = ...,
        version: Optional[int] = ...,
        version_type: Optional[
            Union[Literal["internal", "external", "external_gte", "force"], str]
        ] = ...,
        wait_for_active_shards: Optional[Union[Union[Literal["all"], str], int]] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def bulk(
        self,
        *,
        body: Union[Sequence[Mapping[str, Any]], bytes, str],
        index: Optional[Any] = ...,
        doc_type: Optional[Any] = ...,
        _source: Optional[Any] = ...,
        _source_excludes: Optional[Any] = ...,
        _source_includes: Optional[Any] = ...,
        pipeline: Optional[Any] = ...,
        refresh: Optional[Any] = ...,
        require_alias: Optional[bool] = ...,
        routing: Optional[Any] = ...,
        timeout: Optional[Any] = ...,
        wait_for_active_shards: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def clear_scroll(
        self,
        *,
        body: Optional[Mapping[str, Any]] = ...,
        scroll_id: Optional[Union[List[str], str]] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def count(
        self,
        *,
        body: Optional[Mapping[str, Any]] = ...,
        index: Optional[Any] = ...,
        doc_type: Optional[Any] = ...,
        allow_no_indices: Optional[bool] = ...,
        analyze_wildcard: Optional[bool] = ...,
        analyzer: Optional[Any] = ...,
        default_operator: Optional[Any] = ...,
        df: Optional[Any] = ...,
        expand_wildcards: Optional[Any] = ...,
        ignore_throttled: Optional[bool] = ...,
        ignore_unavailable: Optional[bool] = ...,
        lenient: Optional[bool] = ...,
        min_score: Optional[Any] = ...,
        preference: Optional[Any] = ...,
        q: Optional[Any] = ...,
        routing: Optional[Any] = ...,
        terminate_after: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def delete(
        self,
        *,
        index: str,
        id: str,
        doc_type: Optional[str] = ...,
        if_primary_term: Optional[int] = ...,
        if_seq_no: Optional[int] = ...,
        refresh: Optional[Union[Union[Literal["wait_for"], str], bool]] = ...,
        routing: Optional[str] = ...,
        timeout: Optional[Union[int, str]] = ...,
        version: Optional[int] = ...,
        version_type: Optional[
            Union[Literal["internal", "external", "external_gte", "force"], str]
        ] = ...,
        wait_for_active_shards: Optional[Union[Union[Literal["all"], str], int]] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def delete_by_query(
        self,
        *,
        index: Any,
        body: Mapping[str, Any],
        doc_type: Optional[Any] = ...,
        _source: Optional[Any] = ...,
        _source_excludes: Optional[Any] = ...,
        _source_includes: Optional[Any] = ...,
        allow_no_indices: Optional[bool] = ...,
        analyze_wildcard: Optional[bool] = ...,
        analyzer: Optional[Any] = ...,
        conflicts: Optional[Any] = ...,
        default_operator: Optional[Any] = ...,
        df: Optional[Any] = ...,
        expand_wildcards: Optional[Any] = ...,
        from_: Optional[Any] = ...,
        ignore_unavailable: Optional[bool] = ...,
        lenient: Optional[bool] = ...,
        max_docs: Optional[Any] = ...,
        preference: Optional[Any] = ...,
        q: Optional[Any] = ...,
        refresh: Optional[bool] = ...,
        request_cache: Optional[bool] = ...,
        requests_per_second: Optional[Any] = ...,
        routing: Optional[Any] = ...,
        scroll: Optional[Any] = ...,
        scroll_size: Optional[Any] = ...,
        search_timeout: Optional[Any] = ...,
        search_type: Optional[Any] = ...,
        size: Optional[Any] = ...,
        slices: Optional[Any] = ...,
        sort: Optional[Any] = ...,
        stats: Optional[Any] = ...,
        terminate_after: Optional[Any] = ...,
        timeout: Optional[Any] = ...,
        version: Optional[bool] = ...,
        wait_for_active_shards: Optional[Any] = ...,
        wait_for_completion: Optional[bool] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def delete_by_query_rethrottle(
        self,
        *,
        task_id: Any,
        requests_per_second: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def delete_script(
        self,
        *,
        id: Any,
        master_timeout: Optional[Any] = ...,
        timeout: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def exists(
        self,
        *,
        index: str,
        id: str,
        doc_type: Optional[str] = ...,
        _source: Optional[Union[Union[List[str], str], bool]] = ...,
        _source_excludes: Optional[Union[List[str], str]] = ...,
        _source_includes: Optional[Union[List[str], str]] = ...,
        preference: Optional[str] = ...,
        realtime: Optional[bool] = ...,
        refresh: Optional[bool] = ...,
        routing: Optional[str] = ...,
        stored_fields: Optional[Union[List[str], str]] = ...,
        version: Optional[int] = ...,
        version_type: Optional[
            Union[Literal["internal", "external", "external_gte", "force"], str]
        ] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> bool: ...
    def exists_source(
        self,
        *,
        index: Any,
        id: Any,
        doc_type: Optional[Any] = ...,
        _source: Optional[Any] = ...,
        _source_excludes: Optional[Any] = ...,
        _source_includes: Optional[Any] = ...,
        preference: Optional[Any] = ...,
        realtime: Optional[bool] = ...,
        refresh: Optional[bool] = ...,
        routing: Optional[Any] = ...,
        version: Optional[Any] = ...,
        version_type: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> bool: ...
    def explain(
        self,
        *,
        index: Any,
        id: Any,
        body: Optional[Mapping[str, Any]] = ...,
        doc_type: Optional[Any] = ...,
        _source: Optional[Any] = ...,
        _source_excludes: Optional[Any] = ...,
        _source_includes: Optional[Any] = ...,
        analyze_wildcard: Optional[bool] = ...,
        analyzer: Optional[Any] = ...,
        default_operator: Optional[Any] = ...,
        df: Optional[Any] = ...,
        lenient: Optional[bool] = ...,
        preference: Optional[Any] = ...,
        q: Optional[Any] = ...,
        routing: Optional[Any] = ...,
        stored_fields: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def field_caps(
        self,
        *,
        body: Optional[Mapping[str, Any]] = ...,
        index: Optional[Any] = ...,
        allow_no_indices: Optional[bool] = ...,
        expand_wildcards: Optional[Any] = ...,
        fields: Optional[Any] = ...,
        ignore_unavailable: Optional[bool] = ...,
        include_unmapped: Optional[bool] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def get(
        self,
        *,
        index: str,
        id: str,
        doc_type: Optional[str] = ...,
        _source: Optional[Union[Union[List[str], str], bool]] = ...,
        _source_excludes: Optional[Union[List[str], str]] = ...,
        _source_includes: Optional[Union[List[str], str]] = ...,
        preference: Optional[str] = ...,
        realtime: Optional[bool] = ...,
        refresh: Optional[bool] = ...,
        routing: Optional[str] = ...,
        stored_fields: Optional[Union[List[str], str]] = ...,
        version: Optional[int] = ...,
        version_type: Optional[
            Union[Literal["internal", "external", "external_gte", "force"], str]
        ] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def get_script(
        self,
        *,
        id: Any,
        master_timeout: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def get_source(
        self,
        *,
        index: Any,
        id: Any,
        doc_type: Optional[Any] = ...,
        _source: Optional[Any] = ...,
        _source_excludes: Optional[Any] = ...,
        _source_includes: Optional[Any] = ...,
        preference: Optional[Any] = ...,
        realtime: Optional[bool] = ...,
        refresh: Optional[bool] = ...,
        routing: Optional[Any] = ...,
        version: Optional[Any] = ...,
        version_type: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def mget(
        self,
        *,
        body: Mapping[str, Any],
        index: Optional[Any] = ...,
        doc_type: Optional[Any] = ...,
        _source: Optional[Any] = ...,
        _source_excludes: Optional[Any] = ...,
        _source_includes: Optional[Any] = ...,
        preference: Optional[Any] = ...,
        realtime: Optional[bool] = ...,
        refresh: Optional[bool] = ...,
        routing: Optional[Any] = ...,
        stored_fields: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def msearch(
        self,
        *,
        body: Union[Sequence[Mapping[str, Any]], bytes, str],
        index: Optional[Any] = ...,
        doc_type: Optional[Any] = ...,
        ccs_minimize_roundtrips: Optional[bool] = ...,
        max_concurrent_searches: Optional[Any] = ...,
        max_concurrent_shard_requests: Optional[Any] = ...,
        pre_filter_shard_size: Optional[Any] = ...,
        rest_total_hits_as_int: Optional[bool] = ...,
        search_type: Optional[Any] = ...,
        typed_keys: Optional[bool] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def msearch_template(
        self,
        *,
        body: Union[Sequence[Mapping[str, Any]], bytes, str],
        index: Optional[Any] = ...,
        doc_type: Optional[Any] = ...,
        ccs_minimize_roundtrips: Optional[bool] = ...,
        max_concurrent_searches: Optional[Any] = ...,
        rest_total_hits_as_int: Optional[bool] = ...,
        search_type: Optional[Any] = ...,
        typed_keys: Optional[bool] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def mtermvectors(
        self,
        *,
        body: Optional[Mapping[str, Any]] = ...,
        index: Optional[Any] = ...,
        doc_type: Optional[Any] = ...,
        field_statistics: Optional[bool] = ...,
        fields: Optional[Any] = ...,
        ids: Optional[Any] = ...,
        offsets: Optional[bool] = ...,
        payloads: Optional[bool] = ...,
        positions: Optional[bool] = ...,
        preference: Optional[Any] = ...,
        realtime: Optional[bool] = ...,
        routing: Optional[Any] = ...,
        term_statistics: Optional[bool] = ...,
        version: Optional[Any] = ...,
        version_type: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def put_script(
        self,
        *,
        id: Any,
        body: Mapping[str, Any],
        context: Optional[Any] = ...,
        master_timeout: Optional[Any] = ...,
        timeout: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def rank_eval(
        self,
        *,
        body: Mapping[str, Any],
        index: Optional[Any] = ...,
        allow_no_indices: Optional[bool] = ...,
        expand_wildcards: Optional[Any] = ...,
        ignore_unavailable: Optional[bool] = ...,
        search_type: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def reindex(
        self,
        *,
        body: Mapping[str, Any],
        max_docs: Optional[Any] = ...,
        refresh: Optional[bool] = ...,
        requests_per_second: Optional[Any] = ...,
        scroll: Optional[Any] = ...,
        slices: Optional[Any] = ...,
        timeout: Optional[Any] = ...,
        wait_for_active_shards: Optional[Any] = ...,
        wait_for_completion: Optional[bool] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def reindex_rethrottle(
        self,
        *,
        task_id: Any,
        requests_per_second: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def render_search_template(
        self,
        *,
        body: Optional[Mapping[str, Any]] = ...,
        id: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def scripts_painless_execute(
        self,
        *,
        body: Optional[Mapping[str, Any]] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def scroll(
        self,
        *,
        body: Optional[Mapping[str, Any]] = ...,
        rest_total_hits_as_int: Optional[bool] = ...,
        scroll: Optional[Union[int, str]] = ...,
        scroll_id: Optional[str] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def search(
        self,
        *,
        body: Optional[Mapping[str, Any]] = ...,
        index: Optional[Union[List[str], str]] = ...,
        doc_type: Optional[Union[List[str], str]] = ...,
        _source: Optional[Union[Union[List[str], str], bool]] = ...,
        _source_excludes: Optional[Union[List[str], str]] = ...,
        _source_includes: Optional[Union[List[str], str]] = ...,
        aggregations: Optional[Mapping[str, Mapping[str, Any]]] = ...,
        aggs: Optional[Mapping[str, Mapping[str, Any]]] = ...,
        allow_no_indices: Optional[bool] = ...,
        allow_partial_search_results: Optional[bool] = ...,
        analyze_wildcard: Optional[bool] = ...,
        analyzer: Optional[str] = ...,
        batched_reduce_size: Optional[int] = ...,
        ccs_minimize_roundtrips: Optional[bool] = ...,
        collapse: Optional[Mapping[str, Any]] = ...,
        default_operator: Optional[Union[Literal["AND", "OR"], str]] = ...,
        df: Optional[str] = ...,
        docvalue_fields: Optional[Union[List[str], str]] = ...,
        expand_wildcards: Optional[
            Union[
                List[Union[Literal["all", "open", "closed", "hidden", "none"], str]],
                Union[Literal["all", "open", "closed", "hidden", "none"], str],
                str,
            ]
        ] = ...,
        explain: Optional[bool] = ...,
        fields: Optional[List[Union[Mapping[str, Any], str]]] = ...,
        from_: Optional[int] = ...,
        highlight: Optional[Mapping[str, Any]] = ...,
        ignore_throttled: Optional[bool] = ...,
        ignore_unavailable: Optional[bool] = ...,
        indices_boost: Optional[List[Mapping[str, float]]] = ...,
        lenient: Optional[bool] = ...,
        max_concurrent_shard_requests: Optional[int] = ...,
        min_compatible_shard_node: Optional[str] = ...,
        min_score: Optional[float] = ...,
        pit: Optional[Mapping[str, Any]] = ...,
        post_filter: Optional[Mapping[str, Any]] = ...,
        pre_filter_shard_size: Optional[int] = ...,
        preference: Optional[str] = ...,
        profile: Optional[bool] = ...,
        q: Optional[str] = ...,
        query: Optional[Mapping[str, Any]] = ...,
        request_cache: Optional[bool] = ...,
        rescore: Optional[Union[List[Mapping[str, Any]], Mapping[str, Any]]] = ...,
        rest_total_hits_as_int: Optional[bool] = ...,
        routing: Optional[str] = ...,
        runtime_mappings: Optional[Mapping[str, Mapping[str, Any]]] = ...,
        script_fields: Optional[Mapping[str, Mapping[str, Any]]] = ...,
        scroll: Optional[Union[int, str]] = ...,
        search_after: Optional[List[Union[None, float, int, str]]] = ...,
        search_type: Optional[
            Union[Literal["query_then_fetch", "dfs_query_then_fetch"], str]
        ] = ...,
        seq_no_primary_term: Optional[bool] = ...,
        size: Optional[int] = ...,
        slice: Optional[Mapping[str, Any]] = ...,
        sort: Optional[Union[List[str], str]] = ...,
        stats: Optional[List[str]] = ...,
        stored_fields: Optional[Union[List[str], str]] = ...,
        suggest: Optional[
            Union[Mapping[str, Any], Mapping[str, Mapping[str, Any]]]
        ] = ...,
        suggest_field: Optional[str] = ...,
        suggest_mode: Optional[
            Union[Literal["missing", "popular", "always"], str]
        ] = ...,
        suggest_size: Optional[int] = ...,
        suggest_text: Optional[str] = ...,
        terminate_after: Optional[int] = ...,
        timeout: Optional[Union[int, str]] = ...,
        track_scores: Optional[bool] = ...,
        track_total_hits: Optional[Union[bool, int]] = ...,
        typed_keys: Optional[bool] = ...,
        version: Optional[bool] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def search_shards(
        self,
        *,
        index: Optional[Any] = ...,
        allow_no_indices: Optional[bool] = ...,
        expand_wildcards: Optional[Any] = ...,
        ignore_unavailable: Optional[bool] = ...,
        local: Optional[bool] = ...,
        preference: Optional[Any] = ...,
        routing: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def search_template(
        self,
        *,
        body: Mapping[str, Any],
        index: Optional[Any] = ...,
        doc_type: Optional[Any] = ...,
        allow_no_indices: Optional[bool] = ...,
        ccs_minimize_roundtrips: Optional[bool] = ...,
        expand_wildcards: Optional[Any] = ...,
        explain: Optional[bool] = ...,
        ignore_throttled: Optional[bool] = ...,
        ignore_unavailable: Optional[bool] = ...,
        preference: Optional[Any] = ...,
        profile: Optional[bool] = ...,
        rest_total_hits_as_int: Optional[bool] = ...,
        routing: Optional[Any] = ...,
        scroll: Optional[Any] = ...,
        search_type: Optional[Any] = ...,
        typed_keys: Optional[bool] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def termvectors(
        self,
        *,
        index: Any,
        body: Optional[Mapping[str, Any]] = ...,
        doc_type: Optional[Any] = ...,
        id: Optional[Any] = ...,
        field_statistics: Optional[bool] = ...,
        fields: Optional[Any] = ...,
        offsets: Optional[bool] = ...,
        payloads: Optional[bool] = ...,
        positions: Optional[bool] = ...,
        preference: Optional[Any] = ...,
        realtime: Optional[bool] = ...,
        routing: Optional[Any] = ...,
        term_statistics: Optional[bool] = ...,
        version: Optional[Any] = ...,
        version_type: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def update(
        self,
        *,
        index: str,
        id: str,
        body: Mapping[str, Any],
        doc_type: Optional[str] = ...,
        _source: Optional[Union[Union[List[str], str], bool]] = ...,
        _source_excludes: Optional[Union[List[str], str]] = ...,
        _source_includes: Optional[Union[List[str], str]] = ...,
        detect_noop: Optional[bool] = ...,
        doc: Optional[Any] = ...,
        doc_as_upsert: Optional[bool] = ...,
        if_primary_term: Optional[int] = ...,
        if_seq_no: Optional[int] = ...,
        lang: Optional[str] = ...,
        refresh: Optional[Union[Union[Literal["wait_for"], str], bool]] = ...,
        require_alias: Optional[bool] = ...,
        retry_on_conflict: Optional[int] = ...,
        routing: Optional[str] = ...,
        script: Optional[Union[Mapping[str, Any], str]] = ...,
        scripted_upsert: Optional[bool] = ...,
        timeout: Optional[Union[int, str]] = ...,
        upsert: Optional[Any] = ...,
        wait_for_active_shards: Optional[Union[Union[Literal["all"], str], int]] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def update_by_query(
        self,
        *,
        index: Any,
        body: Optional[Mapping[str, Any]] = ...,
        doc_type: Optional[Any] = ...,
        _source: Optional[Any] = ...,
        _source_excludes: Optional[Any] = ...,
        _source_includes: Optional[Any] = ...,
        allow_no_indices: Optional[bool] = ...,
        analyze_wildcard: Optional[bool] = ...,
        analyzer: Optional[Any] = ...,
        conflicts: Optional[Any] = ...,
        default_operator: Optional[Any] = ...,
        df: Optional[Any] = ...,
        expand_wildcards: Optional[Any] = ...,
        from_: Optional[Any] = ...,
        ignore_unavailable: Optional[bool] = ...,
        lenient: Optional[bool] = ...,
        max_docs: Optional[Any] = ...,
        pipeline: Optional[Any] = ...,
        preference: Optional[Any] = ...,
        q: Optional[Any] = ...,
        refresh: Optional[bool] = ...,
        request_cache: Optional[bool] = ...,
        requests_per_second: Optional[Any] = ...,
        routing: Optional[Any] = ...,
        scroll: Optional[Any] = ...,
        scroll_size: Optional[Any] = ...,
        search_timeout: Optional[Any] = ...,
        search_type: Optional[Any] = ...,
        size: Optional[Any] = ...,
        slices: Optional[Any] = ...,
        sort: Optional[Any] = ...,
        stats: Optional[Any] = ...,
        terminate_after: Optional[Any] = ...,
        timeout: Optional[Any] = ...,
        version: Optional[bool] = ...,
        version_type: Optional[bool] = ...,
        wait_for_active_shards: Optional[Any] = ...,
        wait_for_completion: Optional[bool] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def update_by_query_rethrottle(
        self,
        *,
        task_id: Any,
        requests_per_second: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def get_script_context(
        self,
        *,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def get_script_languages(
        self,
        *,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def close_point_in_time(
        self,
        *,
        body: Optional[Mapping[str, Any]] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def open_point_in_time(
        self,
        *,
        index: Any,
        expand_wildcards: Optional[Any] = ...,
        ignore_unavailable: Optional[bool] = ...,
        keep_alive: Optional[Any] = ...,
        preference: Optional[Any] = ...,
        routing: Optional[Any] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def terms_enum(
        self,
        *,
        index: Any,
        body: Optional[Mapping[str, Any]] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> Dict[str, Any]: ...
    def search_mvt(
        self,
        *,
        index: Union[List[str], str],
        field: str,
        zoom: int,
        x: int,
        y: int,
        body: Optional[Mapping[str, Any]] = ...,
        aggs: Optional[Mapping[str, Mapping[str, Any]]] = ...,
        exact_bounds: Optional[bool] = ...,
        extent: Optional[int] = ...,
        fields: Optional[Union[List[str], str]] = ...,
        grid_precision: Optional[int] = ...,
        grid_type: Optional[Union[Literal["grid", "point", "centroid"], str]] = ...,
        query: Optional[Mapping[str, Any]] = ...,
        runtime_mappings: Optional[Mapping[str, Mapping[str, Any]]] = ...,
        size: Optional[int] = ...,
        sort: Optional[
            Union[
                List[
                    Union[
                        Mapping[str, Any],
                        Union[Literal["asc", "desc", "_doc"], str],
                        str,
                    ]
                ],
                Union[
                    Mapping[str, Any], Union[Literal["asc", "desc", "_doc"], str], str
                ],
            ]
        ] = ...,
        pretty: Optional[bool] = ...,
        human: Optional[bool] = ...,
        error_trace: Optional[bool] = ...,
        format: Optional[str] = ...,
        filter_path: Optional[Union[str, Collection[str]]] = ...,
        request_timeout: Optional[Union[int, float]] = ...,
        ignore: Optional[Union[int, Collection[int]]] = ...,
        opaque_id: Optional[str] = ...,
        http_auth: Optional[Union[str, Tuple[str, str]]] = ...,
        api_key: Optional[Union[str, Tuple[str, str]]] = ...,
        params: Optional[MutableMapping[str, Any]] = ...,
        headers: Optional[MutableMapping[str, str]] = ...,
    ) -> bytes: ...
