
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>

// module includes
#include <BinMDataXtd.hxx>
#include <BinMDataXtd_ConstraintDriver.hxx>
#include <BinMDataXtd_GeometryDriver.hxx>
#include <BinMDataXtd_PatternStdDriver.hxx>
#include <BinMDataXtd_PositionDriver.hxx>
#include <BinMDataXtd_PresentationDriver.hxx>
#include <BinMDataXtd_TriangulationDriver.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BinMDataXtd(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("BinMDataXtd"));
py::object klass;

//Python trampoline classes

// classes

    // Class BinMDataXtd from ./opencascade/BinMDataXtd.hxx
    klass = m.attr("BinMDataXtd");

    // default constructor
    register_default_constructor<BinMDataXtd , shared_ptr<BinMDataXtd>>(m,"BinMDataXtd");

    // nested enums

    static_cast<py::class_<BinMDataXtd , shared_ptr<BinMDataXtd>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("AddDrivers_s",
                    (void (*)( const opencascade::handle<BinMDF_ADriverTable> & ,  const opencascade::handle<Message_Messenger> &  ) ) static_cast<void (*)( const opencascade::handle<BinMDF_ADriverTable> & ,  const opencascade::handle<Message_Messenger> &  ) >(&BinMDataXtd::AddDrivers),
                    R"#(Adds the attribute drivers to <theDriverTable>.)#"  , py::arg("theDriverTable"),  py::arg("aMsgDrv")
          )
        .def_static("SetDocumentVersion_s",
                    (void (*)( const Standard_Integer  ) ) static_cast<void (*)( const Standard_Integer  ) >(&BinMDataXtd::SetDocumentVersion),
                    R"#(None)#"  , py::arg("DocVersion")
          )
        .def_static("DocumentVersion_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&BinMDataXtd::DocumentVersion),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BinMDataXtd_ConstraintDriver from ./opencascade/BinMDataXtd_ConstraintDriver.hxx
    klass = m.attr("BinMDataXtd_ConstraintDriver");


    // nested enums

    static_cast<py::class_<BinMDataXtd_ConstraintDriver ,opencascade::handle<BinMDataXtd_ConstraintDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (BinMDataXtd_ConstraintDriver::*)() const) static_cast<opencascade::handle<TDF_Attribute> (BinMDataXtd_ConstraintDriver::*)() const>(&BinMDataXtd_ConstraintDriver::NewEmpty),
             R"#(None)#" 
          )
        .def("Paste",
             (Standard_Boolean (BinMDataXtd_ConstraintDriver::*)( const BinObjMgt_Persistent & ,  const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinMDataXtd_ConstraintDriver::*)( const BinObjMgt_Persistent & ,  const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinMDataXtd_ConstraintDriver::Paste),
             R"#(None)#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (BinMDataXtd_ConstraintDriver::*)( const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  TColStd_IndexedMapOfTransient &  ) const) static_cast<void (BinMDataXtd_ConstraintDriver::*)( const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  TColStd_IndexedMapOfTransient &  ) const>(&BinMDataXtd_ConstraintDriver::Paste),
             R"#(None)#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&BinMDataXtd_ConstraintDriver::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&BinMDataXtd_ConstraintDriver::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (BinMDataXtd_ConstraintDriver::*)() const) static_cast<const opencascade::handle<Standard_Type> & (BinMDataXtd_ConstraintDriver::*)() const>(&BinMDataXtd_ConstraintDriver::DynamicType),
             R"#(None)#"
             
         )
;

    // Class BinMDataXtd_GeometryDriver from ./opencascade/BinMDataXtd_GeometryDriver.hxx
    klass = m.attr("BinMDataXtd_GeometryDriver");


    // nested enums

    static_cast<py::class_<BinMDataXtd_GeometryDriver ,opencascade::handle<BinMDataXtd_GeometryDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (BinMDataXtd_GeometryDriver::*)() const) static_cast<opencascade::handle<TDF_Attribute> (BinMDataXtd_GeometryDriver::*)() const>(&BinMDataXtd_GeometryDriver::NewEmpty),
             R"#(None)#" 
          )
        .def("Paste",
             (Standard_Boolean (BinMDataXtd_GeometryDriver::*)( const BinObjMgt_Persistent & ,  const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinMDataXtd_GeometryDriver::*)( const BinObjMgt_Persistent & ,  const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinMDataXtd_GeometryDriver::Paste),
             R"#(None)#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (BinMDataXtd_GeometryDriver::*)( const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  TColStd_IndexedMapOfTransient &  ) const) static_cast<void (BinMDataXtd_GeometryDriver::*)( const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  TColStd_IndexedMapOfTransient &  ) const>(&BinMDataXtd_GeometryDriver::Paste),
             R"#(None)#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&BinMDataXtd_GeometryDriver::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&BinMDataXtd_GeometryDriver::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (BinMDataXtd_GeometryDriver::*)() const) static_cast<const opencascade::handle<Standard_Type> & (BinMDataXtd_GeometryDriver::*)() const>(&BinMDataXtd_GeometryDriver::DynamicType),
             R"#(None)#"
             
         )
;

    // Class BinMDataXtd_PatternStdDriver from ./opencascade/BinMDataXtd_PatternStdDriver.hxx
    klass = m.attr("BinMDataXtd_PatternStdDriver");


    // nested enums

    static_cast<py::class_<BinMDataXtd_PatternStdDriver ,opencascade::handle<BinMDataXtd_PatternStdDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (BinMDataXtd_PatternStdDriver::*)() const) static_cast<opencascade::handle<TDF_Attribute> (BinMDataXtd_PatternStdDriver::*)() const>(&BinMDataXtd_PatternStdDriver::NewEmpty),
             R"#(None)#" 
          )
        .def("Paste",
             (Standard_Boolean (BinMDataXtd_PatternStdDriver::*)( const BinObjMgt_Persistent & ,  const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinMDataXtd_PatternStdDriver::*)( const BinObjMgt_Persistent & ,  const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinMDataXtd_PatternStdDriver::Paste),
             R"#(None)#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (BinMDataXtd_PatternStdDriver::*)( const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  TColStd_IndexedMapOfTransient &  ) const) static_cast<void (BinMDataXtd_PatternStdDriver::*)( const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  TColStd_IndexedMapOfTransient &  ) const>(&BinMDataXtd_PatternStdDriver::Paste),
             R"#(None)#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&BinMDataXtd_PatternStdDriver::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&BinMDataXtd_PatternStdDriver::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (BinMDataXtd_PatternStdDriver::*)() const) static_cast<const opencascade::handle<Standard_Type> & (BinMDataXtd_PatternStdDriver::*)() const>(&BinMDataXtd_PatternStdDriver::DynamicType),
             R"#(None)#"
             
         )
;

    // Class BinMDataXtd_PositionDriver from ./opencascade/BinMDataXtd_PositionDriver.hxx
    klass = m.attr("BinMDataXtd_PositionDriver");


    // nested enums

    static_cast<py::class_<BinMDataXtd_PositionDriver ,opencascade::handle<BinMDataXtd_PositionDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (BinMDataXtd_PositionDriver::*)() const) static_cast<opencascade::handle<TDF_Attribute> (BinMDataXtd_PositionDriver::*)() const>(&BinMDataXtd_PositionDriver::NewEmpty),
             R"#(None)#" 
          )
        .def("Paste",
             (Standard_Boolean (BinMDataXtd_PositionDriver::*)( const BinObjMgt_Persistent & ,  const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinMDataXtd_PositionDriver::*)( const BinObjMgt_Persistent & ,  const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinMDataXtd_PositionDriver::Paste),
             R"#(None)#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (BinMDataXtd_PositionDriver::*)( const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  TColStd_IndexedMapOfTransient &  ) const) static_cast<void (BinMDataXtd_PositionDriver::*)( const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  TColStd_IndexedMapOfTransient &  ) const>(&BinMDataXtd_PositionDriver::Paste),
             R"#(None)#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&BinMDataXtd_PositionDriver::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&BinMDataXtd_PositionDriver::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (BinMDataXtd_PositionDriver::*)() const) static_cast<const opencascade::handle<Standard_Type> & (BinMDataXtd_PositionDriver::*)() const>(&BinMDataXtd_PositionDriver::DynamicType),
             R"#(None)#"
             
         )
;

    // Class BinMDataXtd_PresentationDriver from ./opencascade/BinMDataXtd_PresentationDriver.hxx
    klass = m.attr("BinMDataXtd_PresentationDriver");


    // nested enums

    static_cast<py::class_<BinMDataXtd_PresentationDriver ,opencascade::handle<BinMDataXtd_PresentationDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (BinMDataXtd_PresentationDriver::*)() const) static_cast<opencascade::handle<TDF_Attribute> (BinMDataXtd_PresentationDriver::*)() const>(&BinMDataXtd_PresentationDriver::NewEmpty),
             R"#(None)#" 
          )
        .def("Paste",
             (Standard_Boolean (BinMDataXtd_PresentationDriver::*)( const BinObjMgt_Persistent & ,  const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinMDataXtd_PresentationDriver::*)( const BinObjMgt_Persistent & ,  const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinMDataXtd_PresentationDriver::Paste),
             R"#(None)#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (BinMDataXtd_PresentationDriver::*)( const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  TColStd_IndexedMapOfTransient &  ) const) static_cast<void (BinMDataXtd_PresentationDriver::*)( const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  TColStd_IndexedMapOfTransient &  ) const>(&BinMDataXtd_PresentationDriver::Paste),
             R"#(None)#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&BinMDataXtd_PresentationDriver::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&BinMDataXtd_PresentationDriver::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (BinMDataXtd_PresentationDriver::*)() const) static_cast<const opencascade::handle<Standard_Type> & (BinMDataXtd_PresentationDriver::*)() const>(&BinMDataXtd_PresentationDriver::DynamicType),
             R"#(None)#"
             
         )
;

    // Class BinMDataXtd_TriangulationDriver from ./opencascade/BinMDataXtd_TriangulationDriver.hxx
    klass = m.attr("BinMDataXtd_TriangulationDriver");


    // nested enums

    static_cast<py::class_<BinMDataXtd_TriangulationDriver ,opencascade::handle<BinMDataXtd_TriangulationDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (BinMDataXtd_TriangulationDriver::*)() const) static_cast<opencascade::handle<TDF_Attribute> (BinMDataXtd_TriangulationDriver::*)() const>(&BinMDataXtd_TriangulationDriver::NewEmpty),
             R"#(None)#" 
          )
        .def("Paste",
             (Standard_Boolean (BinMDataXtd_TriangulationDriver::*)( const BinObjMgt_Persistent & ,  const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinMDataXtd_TriangulationDriver::*)( const BinObjMgt_Persistent & ,  const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinMDataXtd_TriangulationDriver::Paste),
             R"#(None)#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (BinMDataXtd_TriangulationDriver::*)( const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  TColStd_IndexedMapOfTransient &  ) const) static_cast<void (BinMDataXtd_TriangulationDriver::*)( const opencascade::handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  TColStd_IndexedMapOfTransient &  ) const>(&BinMDataXtd_TriangulationDriver::Paste),
             R"#(None)#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&BinMDataXtd_TriangulationDriver::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&BinMDataXtd_TriangulationDriver::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (BinMDataXtd_TriangulationDriver::*)() const) static_cast<const opencascade::handle<Standard_Type> & (BinMDataXtd_TriangulationDriver::*)() const>(&BinMDataXtd_TriangulationDriver::DynamicType),
             R"#(None)#"
             
         )
;

// functions
// ./opencascade/BinMDataXtd.hxx
// ./opencascade/BinMDataXtd_ConstraintDriver.hxx
// ./opencascade/BinMDataXtd_GeometryDriver.hxx
// ./opencascade/BinMDataXtd_PatternStdDriver.hxx
// ./opencascade/BinMDataXtd_PositionDriver.hxx
// ./opencascade/BinMDataXtd_PresentationDriver.hxx
// ./opencascade/BinMDataXtd_TriangulationDriver.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
