/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "aboutqchat.h"

#include <QLayout>
#include <QTabWidget>
#include <QTextBrowser>
#include <QLabel>
#include <QApplication>
#include <QPushButton>

#include "globals.h"

AboutQChat::AboutQChat(QWidget *parent)
 : QDialog(parent)
{
  QString msg;

  QGridLayout* grid = new QGridLayout(this);
  QTabWidget*  tabs = new QTabWidget(this);
  QTextBrowser* tab = new QTextBrowser(this);
  QLabel*      lab  = new QLabel(this);
  QPushButton* btn  = new QPushButton(tr("Close"), this);

  lab->setPixmap(QApplication::windowIcon().pixmap(64));

  grid->addWidget(lab, 0, 0);

  lab  = new QLabel(this);

  lab->setText(QString("<b>QChat ") + Globals::VersionsTable[Globals::VersionID - 1] + QString(" (%1)").arg(Globals::Revision) + "</b>");
  lab->setAlignment(Qt::AlignCenter);

  grid->addWidget(lab, 0, 1);
  grid->addWidget(tabs, 1, 0, 1, 2);
  grid->addWidget(btn, 2, 1, Qt::AlignRight);

  grid->setColumnStretch(1, 1);

  msg.append(tr("<br><center>Network chat.</center><br>\n")).
      append("<br>&nbsp;&nbsp;(c) 2007-2008, Anistratov Oleg aka ower"
             "<br>&nbsp;&nbsp;<a href=\"mailto:ower@users.sourceforge.net\">ower@users.sourceforge.net</a>");

  tab->setOpenExternalLinks(true);
  tab->setHtml(msg);
  tab->setWordWrapMode(QTextOption::NoWrap);
  tabs->addTab(tab, tr("About"));

  msg = "&nbsp;Ower"
        "<br>&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"mailto:ower@users.sourceforge.net\">ower@users.sourceforge.net</a>"
        "<br>&nbsp;&nbsp;&nbsp;&nbsp;Ukrainian, Russian translations"
        "<br><br>&nbsp;Adrian Lubik"
        "<br>&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"mailto:adrian5632@gmail.com\">adrian5632@gmail.com</a> "
        "<br>&nbsp;&nbsp;&nbsp;&nbsp;Polish translation"
        "<br><br>&nbsp;Salas Jose Luis"
        "<br>&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"mailto:josacar@gmail.com\">josacar@gmail.com</a> "
        "<br>&nbsp;&nbsp;&nbsp;&nbsp;Spanish translation"
        "<br><br>&nbsp;Karsten Brockmann"
        "<br>&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"mailto:arcam@ccux-linux.de\">arcam@ccux-linux.de</a> "
        "<br>&nbsp;&nbsp;&nbsp;&nbsp;German translation"
        "<br><br>&nbsp;Alen Keri"
        "<br>&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"mailto:kosava@gmail.com\">kosava@gmail.com</a> "
        "<br>&nbsp;&nbsp;&nbsp;&nbsp;Serbian translation";


  tab = new QTextBrowser(this);
  tab->setOpenExternalLinks(true);
  tab->setHtml(msg);
  tabs->addTab(tab, tr("Translations"));

  grid->setMargin(3);
  grid->setSpacing(10);

  connect(btn, SIGNAL(clicked()), this, SLOT(accept()));

  setMinimumWidth(400);
  setMinimumHeight(300);

  setWindowTitle(tr("About QChat"));
}

AboutQChat::~AboutQChat()
{
  qDebug("[~AboutQChat]");
}

