/*
    aboutInfo

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>
				  2009 by Nigmatullin Ruslan <euroelessar@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/
#include "aboutinfo.h"
#include <QResource>
#include <QCoreApplication>
#include <QDialog>
#include <QVBoxLayout>
#include <QPointer>

aboutInfo::aboutInfo(QWidget *parent)
    : QWidget(parent)
{
	ui.setupUi(this);
	setAttribute(Qt::WA_QuitOnClose, false);
	setAttribute(Qt::WA_DeleteOnClose, true);
	ui.label->setText(ui.label->text().arg(QCoreApplication::applicationVersion(), QLatin1String(qVersion())));
	ui.label_3->setText(ui.label_3->text().arg(tr("Support project with a donation:"), tr("Yandex.Money")));
	QString translators = tr("Enter there your names, dear translaters");
	if(translators == QLatin1String("Enter there your names, dear translaters"))
		ui.tabWidget->removeTab(3);
	else
		ui.translatorsTextBrowser->setText(translators);
	connect(ui.label_4, SIGNAL(linkActivated(QString)), this, SLOT(showLicense()));
}

void aboutInfo::showLicense()
{
	static QPointer<QDialog> license;
	if(!license.isNull())
	{
		license->show();
		license->raise();
		return;
	}
	license = new QDialog(this);
	license->setWindowTitle(tr("GNU General Public License, version 2"));
	license->setMinimumSize(500, 400);
	QVBoxLayout *layout = new QVBoxLayout(license);
	QTextBrowser *browser = new QTextBrowser(license);
	layout->addWidget(browser);
	browser->setText(QLatin1String((const char *)QResource( ":/GPL" ).data()));
	license->show();
}

aboutInfo::~aboutInfo()
{

}
