**Checklist**
Thank you for contributing to QuTiP! Please make sure you have finished the following tasks before opening the PR.

- [ ] Please read [Contributing to QuTiP Development](http://qutip.org/docs/latest/development/contributing.html)
- [ ] Contributions to qutip should follow the [pep8 style](https://www.python.org/dev/peps/pep-0008/).
You can use [pycodestyle](http://pycodestyle.pycqa.org/en/latest/index.html) to check your code automatically
- [ ] Please add tests to cover your changes if applicable.
- [ ] If the behavior of the code has changed or new feature has been added, please also update the documentation in the `doc` folder, and the [notebook](https://github.com/qutip/qutip-notebooks). Feel free to ask if you are not sure.

Delete this checklist after you have completed all the tasks. If you have not finished them all, you can also open a [Draft Pull Request](https://github.blog/2019-02-14-introducing-draft-pull-requests/) to let the others know this on-going work and keep this checklist in the PR description.

**Description**
Describe here the proposed change.

**Related issues or PRs**
Please mention the related issues or PRs here. If the PR fixes an issue, use the keyword fix/fixes/fixed followed by the issue id, e.g. fix #1184

**Changelog**
Give a short description of the PR in a few words. This will be shown in the QuTiP change log after the PR gets merged.
For example: 
Fixed error checking for null matrix in essolve.
Added option for specifying resolution in Bloch.save function.
