% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-name.R
\name{is_table_path}
\alias{is_table_path}
\alias{table_path_name}
\alias{table_path_components}
\alias{check_table_path}
\alias{as_table_path}
\title{Table paths}
\usage{
is_table_path(x)

table_path_name(x, con)

table_path_components(x, con)

check_table_path(x, error_arg = caller_arg(x), error_call = caller_env())

as_table_path(x, con, error_arg = caller_arg(x), error_call = caller_env())
}
\description{
dbplyr standardises all the ways of referring to a table (i.e. a single
string, a string wrapped in \code{I()}, a \code{\link[DBI:Id]{DBI::Id()}} and the results of
\code{\link[=in_schema]{in_schema()}} and \code{\link[=in_catalog]{in_catalog()}}) into a table "path" of the form
\code{table}, \code{schema.table}, or \code{catalog.schema.path}. A table path is
always suitable for inlining into a query, so user input is quoted unless
it is wrapped in \code{I()}.

This is primarily for internal usage, but you may need to work with it if
you're implementing a backend, and you need to compute with the table path,
not just pass it on unchanged to some other dbplyr function.
\itemize{
\item \code{is_table_path()} returns \code{TRUE} if the object is a \code{table_path}.
\item \code{as_table_path()} coerces known table identifiers to a \code{table_path}.
\item \code{check_table_path()} throws an error if the object is not a \code{table_path}.
\item \code{table_path_name()} returns the last component of the table path (i.e.
the name of the table).
\item \code{table_path_components()} returns a list containing the components of each
table path.
}

A \code{table_path} object can technically be a vector of table paths, but
you will never see this in table paths constructed from user inputs.
}
\keyword{internal}
