% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_degenerate.R
\name{dist_degenerate}
\alias{dist_degenerate}
\title{The degenerate distribution}
\usage{
dist_degenerate(x)
}
\arguments{
\item{x}{The value of the distribution.}
}
\description{
\lifecycle{stable}
}
\details{
The degenerate distribution takes a single value which is certain to be
observed. It takes a single parameter, which is the value that is observed
by the distribution.

We recommend reading this documentation on
\url{https://pkg.mitchelloharawild.com/distributional/}, where the math
will render nicely.

In the following, let \eqn{X} be a degenerate random variable with value
\code{x} = \eqn{k_0}.

\strong{Support}: \eqn{R}, the set of all real numbers

\strong{Mean}: \eqn{k_0}

\strong{Variance}: \eqn{0}

\strong{Probability density function (p.d.f)}:

\deqn{
    f(x) = 1 for x = k_0
  }{
    f(x) = 1 for x = k_0
  }
\deqn{
    f(x) = 0 for x \neq k_0
  }{
    f(x) = 0 for x \neq k_0
  }

\strong{Cumulative distribution function (c.d.f)}:

The cumulative distribution function has the form

\deqn{
    F(x) = 0 for x < k_0
  }{
    F(x) = 0 for x < k_0
  }
\deqn{
    F(x) = 1 for x \ge k_0
  }{
    F(x) = 1 for x \ge k_0
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = e^{k_0 t}
  }{
    E(e^(tX)) = e^(k_0 t)
  }
}
\examples{
dist_degenerate(x = 1:5)

}
