% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font-getters.R
\name{font_families}
\alias{font_faces}
\alias{font_families}
\title{Font families and faces}
\usage{
font_families(fontset)

font_faces(fontset, family = c("sans", "serif", "mono", "symbol"))
}
\arguments{
\item{fontset}{A string giving the name of a set of fonts
(e.g. \code{"Liberation"} or\code{"Bitstream Vera"}). Use
\code{\link{fontset_list}()} to obtain the list of fontsets
registered in your session.}

\item{family}{One of \code{"sans"}, \code{"serif"}, \code{"mono"}
or \code{"symbol"}.}
}
\description{
Returns families or faces as font files for a given font set. The
files are organised by R nomenclature of families (\code{"sans"},
\code{"serif"}, \code{"mono"}, and \code{"symbol"}) and faces
(\code{"plain"}, \code{"italic"}, \code{"bold"}, and
\code{"bolditalic"}). When a font does not have a combination,
\code{NA} is reported.
}
\details{
Note that the fonts returned by \code{font_faces()} and
\code{\link{font_families}()} are constrained by R's nomenclature
of fonts and are thus a subset of those returned by
\code{\link{font_variants}()} and \code{\link{font_styles}()}.
}
\examples{
font_families("Bitstream Vera")$mono$bold
font_faces("Bitstream Vera", "mono")
}
\seealso{
\code{\link{font_variants}()}, \code{\link{fonts}()}
}

