% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/push.R
\name{push}
\alias{push}
\title{Push}
\usage{
push(object = ".", name = NULL, refspec = NULL, force = FALSE,
  credentials = NULL, set_upstream = FALSE)
}
\arguments{
\item{object}{path to repository, or a \code{git_repository} or
\code{git_branch}.}

\item{name}{The remote's name. Default is NULL.}

\item{refspec}{The refspec to be pushed. Default is NULL.}

\item{force}{Force your local revision to the remote repo. Use it
with care. Default is FALSE.}

\item{credentials}{The credentials for remote repository
access. Default is NULL. To use and query an ssh-agent for the
ssh key credentials, let this parameter be NULL (the default).}

\item{set_upstream}{Set the current local branch to track the
remote branch. Default is FALSE.}
}
\value{
invisible(NULL)
}
\description{
Push
}
\examples{
\dontrun{
## Initialize two temporary repositories
path_bare <- tempfile(pattern="git2r-")
path_repo <- tempfile(pattern="git2r-")
dir.create(path_bare)
dir.create(path_repo)
repo_bare <- init(path_bare, bare = TRUE)

## Clone the bare repository. This creates remote-tracking
## branches for each branch in the cloned repository.
repo <- clone(path_bare, path_repo)

## Config user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")

## Write to a file and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path_repo, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Push commits from repository to bare repository
push(repo, "origin", "refs/heads/master")

## Now, unset the remote-tracking branch to NULL to demonstrate
## the 'set_upstream' argument. Then push with 'set_upstream = TRUE'
## to add the upstream tracking branch to branch 'master' again.
branch_get_upstream(repository_head(repo))
branch_set_upstream(repository_head(repo), NULL)
branch_get_upstream(repository_head(repo))
push(repo, "origin", "refs/heads/master", set_upstream = TRUE)
branch_get_upstream(repository_head(repo))

## Change file and commit
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua."),
           file.path(path_repo, "example.txt"))
add(repo, "example.txt")
commit(repo, "Second commit message")

## Push commits from repository to bare repository
push(repo)

## List commits in repository and bare repository
commits(repo)
commits(repo_bare)
}
}
\seealso{
\code{\link{cred_user_pass}}, \code{\link{cred_ssh_key}}
}
