% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_drive_rm.R
\name{shared_drive_rm}
\alias{shared_drive_rm}
\title{Delete shared drives}
\usage{
shared_drive_rm(drive = NULL)
}
\arguments{
\item{drive}{Anything that identifies the shared drive(s) of interest. Can
be a character vector of names, a character vector of file ids or URLs
marked with \code{\link[=as_id]{as_id()}}, or a \code{\link{dribble}} consisting only of shared drives.}
}
\value{
Logical vector, indicating whether the delete succeeded.
}
\description{
A shared drive supports files owned by an organization rather than an
individual user. Shared drives follow different sharing and ownership models
from a specific user's "My Drive". Shared drives are the successors to the
earlier concept of Team Drives. Learn more about \link[=shared_drives]{shared drives}.
}
\examples{
\dontrun{
# Create shared drives to remove in various ways
shared_drive_create("testdrive-01")
sd02 <- shared_drive_create("testdrive-02")
shared_drive_create("testdrive-03")
sd04 <- shared_drive_create("testdrive-04")

# remove by name
shared_drive_rm("testdrive-01")
# remove by id
shared_drive_rm(as_id(sd02))
# remove by URL (or, rather, id found in URL)
shared_drive_rm(as_id("https://drive.google.com/drive/u/0/folders/Q5DqUk9PVA"))
# remove by dribble
shared_drive_rm(sd04)
}
}
\seealso{
Wraps the \code{drives.delete} endpoint:
\itemize{
\item \url{https://developers.google.com/drive/api/v3/reference/drives/delete}
}
}
