% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gvisAnnotationChart.R
\name{gvisAnnotationChart}
\alias{gvisAnnotationChart}
\title{Google Annotation Chart with R
\Sexpr{googleChartName <- "annotationchart"}
\Sexpr{gvisChartName <- "gvisAnnotationChart"}}
\usage{
gvisAnnotationChart(
  data,
  datevar = "",
  numvar = "",
  idvar = "",
  titlevar = "",
  annotationvar = "",
  date.format = "\%Y/\%m/\%d",
  options = list(),
  chartid
)
}
\arguments{
\item{data}{a \code{data.frame}. The data has to have at least two columns,
one with date information (\code{datevar}) and one numerical variable.}

\item{datevar}{column name of \code{data} which shows the date dimension.
The information has to be of class \code{\link{Date}} or \code{POSIX*} time
series.}

\item{numvar}{column name of \code{data} which shows the values to be
displayed against \code{datevar}. The information has to be
\code{\link{numeric}}.}

\item{idvar}{column name of \code{data} which identifies different groups of
the data. The information has to be of class \code{\link{character}} or
\code{\link{factor}}.}

\item{titlevar}{column name of \code{data} which shows the title of the
annotations. The information has to be of class \code{\link{character}} or
\code{\link{factor}}.  Missing information can be set to \code{NA}. See
section 'Details' for more details.}

\item{annotationvar}{column name of \code{data} which shows the annotation
text. The information has to be of class \code{\link{character}} or
\code{\link{factor}}. Missing information can be set to \code{NA}. See
section 'Details' for more details.}

\item{date.format}{if \code{datevar} is of class \code{\link{Date}} then
this argument specifies how the dates are reformatted to be used by
JavaScript.}

\item{options}{list of configuration options, see:

% START DYNAMIC CONTENT

\Sexpr[results=rd]{gsub("CHARTNAME", 
googleChartName,
readLines(file.path(".", "inst",  "mansections", 
"GoogleChartToolsURLConfigOptions.txt")))}

 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst", 
 "mansections", "gvisOptions.txt")))}}

\item{chartid}{character. If missing (default) a random chart id will be 
generated based on chart type and \code{\link{tempfile}}.}
}
\value{
\Sexpr[results=rd]{paste(gvisChartName)} returns list 
of \code{\link{class}}
 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst", 
 "mansections", "gvisOutputStructure.txt")))}
}
\description{
gvisAnnotationChart charts are interactive time series line charts that support 
annotations. Unlike the gvisAnnotatedTimeLine, which uses Flash, 
annotation charts are SVG/VML and should be preferred whenever possible.
}
\examples{

## Please note that by default the googleVis plot command
## will open a browser window and requires Internet
## connection to display the visualisation.


data(Stock)
Stock
A1 <- gvisAnnotationChart(Stock, datevar="Date",
                           numvar="Value", idvar="Device",
                           titlevar="Title", annotationvar="Annotation",
                           options=list(displayAnnotations=TRUE,
                            legendPosition='newRow',
                            width=600, height=350)
                           )
plot(A1)

## Two Y-axis
A2 <- gvisAnnotationChart(Stock, datevar="Date",
                           numvar="Value", idvar="Device",
                           titlevar="Title", annotationvar="Annotation",
                           options=list(displayAnnotations=TRUE, 
                            width=600, height=350, scaleColumns='[0,1]',
                            scaleType='allmaximized')
                          )
plot(A2)



## Colouring the area below the lines to create an area chart
A3 <- gvisAnnotationChart(Stock, datevar="Date",
                           numvar="Value", idvar="Device",
                           titlevar="Title", annotationvar="Annotation",
                           options=list(
                             width=600, height=350,
                             fill=10, displayExactValues=TRUE,
                             colors="['#0000ff','#00ff00']")
                           )
                          
plot(A3)


## Data with POSIXct datetime variable
A4 <- gvisAnnotationChart(Andrew, datevar="Date/Time UTC",
                            numvar="Pressure_mb",
                            options=list(scaleType='maximized')
                            )

plot(A4)

# Change background to blue
A5 <- gvisAnnotationChart(Stock, datevar="Date",
              numvar="Value", idvar="Device",
              titlevar="Title", annotationvar="Annotation",
              options=list(
                displayAnnotations=TRUE,
                  chart = "{chartArea:{backgroundColor:'#003b70'}}",
                            legendPosition='newRow',
                            width=600, height=350))
                            
plot(A5)

}
\references{
Google Chart Tools API: 
\Sexpr[results=rd]{gsub("CHARTNAME", 
googleChartName, 
readLines(file.path(".", "inst",  "mansections", 
"GoogleChartToolsURL.txt")))}

% END DYNAMIC CONTENT
}
\seealso{
See also \code{\link{print.gvis}}, \code{\link{plot.gvis}} for printing and
plotting methods. Further see \code{\link{reshape}} for reshaping data, e.g.
from a wide format into a long format.
}
\author{
Markus Gesmann \email{markus.gesmann@gmail.com},
Diego de Castillo \email{decastillo@gmail.com}
}
\keyword{iplot}
