\name{getDynLib-methods}
\docType{methods}
\alias{getDynLib}
\alias{getDynLib-methods}
\alias{getDynLib,CFunc-method}
\alias{getDynLib,character-method}
\alias{getDynLib,CFuncList-method}
\title{Retrieve the dynamic library (or DLL) associated with a package of 
a function generated by cfunction}
\description{
The \code{getDynLib} function retrieves the dynamic library (or DLL) 
associated with a package or with a function generated by 
\code{\link{cfunction}}
}
\section{Methods}{
\describe{

\item{\code{signature(x = "CFunc")}}{Retrieves the dynamic 
library associated with the function generated by \code{\link{cfunction}}. 
The library is dynamically loaded if necessary. }

\item{\code{signature(x = "CFuncList")}}{Retrieves the dynamic 
library associated with a set of functions generated by \code{\link{cfunction}}. 
The library is dynamically loaded if necessary. }

\item{\code{signature(x = "character")}}{
Retrieves the dynamic library of the given name. This typically refers 
to package names, but can be any name of the list returned by 
\code{\link{getLoadedDLLs}}
}
}}
\seealso{\code{\link{getLoadedDLLs}}, \code{\link{dyn.load}} }
\examples{
\dontrun{
getDynLib( "base" )

f <- cfunction( signature() , "return R_NilValue ;" )
getDynLib( f )

}}
\keyword{methods}

