% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paretoTail.R
\name{replaceTail}
\alias{replaceTail}
\alias{replaceTail.paretoTail}
\alias{replaceOut}
\title{Replace observations under a Pareto model}
\usage{
replaceTail(x, ...)

\method{replaceTail}{paretoTail}(x, all = TRUE, ...)

replaceOut(x, ...)
}
\arguments{
\item{x}{an object of class \code{"paretoTail"} (see
\code{\link{paretoTail}}).}

\item{\dots}{additional arguments to be passed down.}

\item{all}{a logical indicating whether all observations in the upper tail
should be replaced or only those flagged as outliers.}
}
\value{
A numeric vector consisting mostly of the original values, but with
observations in the upper tail replaced with values from the fitted Pareto
distribution.
}
\description{
Replace observations under a Pareto model for the upper tail with values
drawn from the fitted distribution.
}
\details{
\code{replaceOut(x, \dots{})} is a simple wrapper for \code{replaceTail(x,
all = FALSE, \dots{})}.
}
\examples{
data(eusilc)


## gini coefficient without Pareto tail modeling
gini("eqIncome", weights = "rb050", data = eusilc)


## gini coefficient with Pareto tail modeling

# estimate threshold
ts <- paretoScale(eusilc$eqIncome, w = eusilc$db090,
    groups = eusilc$db030)

# estimate shape parameter
fit <- paretoTail(eusilc$eqIncome, k = ts$k,
    w = eusilc$db090, groups = eusilc$db030)

# replacement of outliers
eqIncome <- replaceOut(fit)
gini(eqIncome, weights = eusilc$rb050)

# replacement of whole tail
eqIncome <- replaceTail(fit)
gini(eqIncome, weights = eusilc$rb050)

}
\references{
A. Alfons and M. Templ (2013) Estimation of Social Exclusion Indicators
from Complex Surveys: The \R Package \pkg{laeken}.  \emph{Journal of
Statistical Software}, \bold{54}(15), 1--25.  \doi{10.18637/jss.v054.i15}

A. Alfons, M. Templ, P. Filzmoser (2013) Robust estimation of economic
indicators from survey samples based on Pareto tail modeling. \emph{Journal
of the Royal Statistical Society, Series C}, \bold{62}(2), 271--286.
}
\seealso{
\code{\link{paretoTail}}, \code{\link{reweightOut}},
\code{\link{shrinkOut}}
}
\author{
Andreas Alfons
}
\keyword{manip}
