% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.r
\name{mnsl2hvc}
\alias{mnsl2hvc}
\title{Converts a Munsell colour to a hue, chroma and value triplet}
\usage{
mnsl2hvc(col, ...)
}
\arguments{
\item{col}{a character vector of Munsell colours}

\item{...}{passed on to \code{\link{check_mnsl}}. Use \code{fix = TRUE} to
fix "bad" colours}
}
\value{
a data frame with named columns hue, value and chroma containing the hue,
value and chroma levels.
}
\description{
Takes a text specification of a Munsell colour and returns
the hue, chroma and value triplet.
}
\details{
Munsell colours are specified by hue, value and chroma.  They 
take a form like "5PB 5/10" where the first characters represent the
hue, followed by a space then the value and chroma separated by a "/". In
this package value should be an integer in 0:10 and chroma an even number
at most 24.  Note that not all possible specifications result in 
representable colours.
}
\examples{
mnsl2hvc("5PB 5/10")
hvc2mnsl(mnsl2hvc("5PB 5/10"))
}
\seealso{
\code{\link{check_mnsl}}, \code{\link{hvc2mnsl}}
}
