% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_function.R
\name{function-nodes}
\alias{function-nodes}
\alias{pd_is_function}
\alias{pd_is_in_function}
\alias{pd_get_function_body_id}
\alias{pd_get_function_arg_ids}
\alias{pd_get_function_arg_variable_ids}
\alias{pd_get_function_arg_variable_text}
\alias{pd_is_function_arg}
\alias{pd_get_function_arg_associated_comment_ids}
\title{Function Nodes}
\usage{
pd_is_function(id, pd, .check = TRUE)

pd_is_in_function(id, pd, .check = TRUE)

pd_get_function_body_id(id, pd, .check = TRUE)

pd_get_function_arg_ids(id, pd, .check = TRUE)

pd_get_function_arg_variable_ids(id, pd, .check = TRUE)

pd_get_function_arg_variable_text(id, pd, .check = TRUE)

pd_is_function_arg(id, pd, .check = TRUE)

pd_get_function_arg_associated_comment_ids(id, pd, .check = TRUE)
}
\arguments{
\item{id}{id of the expression of interest}

\item{pd}{The \code{\link{parse-data}} information}

\item{.check}{Perform checks for input validation?}
}
\description{
These function help identify and navigate noses associated with
function definition.
}
\details{
A function node is the node for the expression that has as it's
children the function keyword(firstborn), the arguments, including the
nodes representing the opening closing parentheses in the definition,
and finally a node, as the youngest, for the body of the function.
}
\section{Functions}{
\itemize{
\item \code{pd_is_function}: Test if the \code{id} points to a function.

\item \code{pd_is_in_function}: test if a node is contained in a function definition.

\item \code{pd_get_function_body_id}: Obtain the body of a function

\item \code{pd_get_function_arg_ids}: Obtain the ids for the arguments of a function

\item \code{pd_get_function_arg_variable_ids}: Retrieve the variable for a function argument

\item \code{pd_get_function_arg_variable_text}: Get the variable names for a function definition.

\item \code{pd_is_function_arg}: is \code{id} a function argument?

\item \code{pd_get_function_arg_associated_comment_ids}: Retrieve relative documentation comments associated with function arguments.
}}

\examples{
# load example file and get_parse data
ex.file <- system.file("examples", "example.R", package="parsetools")
exprs <- parse(ex.file, keep.source = TRUE)
pd <- get_parse_data(exprs)

# There are 3 expressions so there should be three roots.
sum(pd_is_root(pd$id, pd))
roots <- pd_all_root_ids(pd)

function.id <- pd_get_assign_value_id(roots[[1]], pd)
pd_is_function(function.id, pd)
length(function.kids <- pd_get_children_ids(function.id, pd))
# function nodes have many because it contains
# 1. the function keyword.
# 2. the parentheses '(' and ')'
# 3. each argument name plus the equals sign and value, if given.
# 4. and finally, and expr node for the function body.
pd_token(function.kids, pd)
# even though there are only two argument since each has
# a default value given there are 6 total nodes that
# return true as function arguments, care is needed when
# dealing with function arguments.
pd_is_function_arg(function.kids, pd)
pd_get_function_arg_ids(function.id, pd)
# A simple way to identify the argument names is
pd_get_function_arg_variable_text(function.id, pd)

# To identify the function body node.
pd_get_function_body_id(function.id, pd)

}
