% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyCub.exact.Gauss.R
\name{polyCub.exact.Gauss}
\alias{polyCub.exact.Gauss}
\title{Quasi-Exact Cubature of the Bivariate Normal Density}
\usage{
polyCub.exact.Gauss(polyregion, mean = c(0, 0), Sigma = diag(2),
  plot = FALSE)
}
\arguments{
\item{polyregion}{a \code{"\link[rgeos:gpc.poly-class]{gpc.poly}"} polygon or
something that can be coerced to this class, e.g., an \code{"owin"} polygon
(converted via \code{\link{owin2gpc}} and -- given \pkg{rgeos} is available
-- \code{"SpatialPolygons"} also work.}

\item{mean, Sigma}{mean and covariance matrix of the bivariate normal density
to be integrated.}

\item{plot}{logical indicating if an illustrative plot of the numerical
integration should be produced. Note that the \code{polyregion} will be
transformed (shifted and scaled).}
}
\value{
The integral of the bivariate normal density over \code{polyregion}.
Two attributes are appended to the integral value:
\item{nEval}{
number of triangles over which the standard bivariate normal density had to
be integrated, i.e. number of calls to \code{\link[mvtnorm]{pmvnorm}} and
\code{\link[stats]{pnorm}}, the former of which being the most time-consuming
operation.
}
\item{error}{
Approximate absolute integration error stemming from the error introduced by
the \code{nEval} \code{\link[mvtnorm]{pmvnorm}} evaluations.
For this reason, the cubature method is in fact only
quasi-exact (as is the \code{pmvnorm} function).
}
}
\description{
Integration is based on triangulation of the (transformed) polygonal domain
and formulae from the
Abramowitz and Stegun (1972) handbook (Section 26.9, Example 9, pp. 956f.).
This method is quite cumbersome because the A&S formula is only for triangles
where one vertex is the origin (0,0). For each triangle of the
\code{\link[gpclib]{tristrip}} we have to check in which of the 6 outer
regions of the triangle the origin (0,0) lies and adapt the signs in the
formula appropriately: \eqn{(AOB+BOC-AOC)} or \eqn{(AOB-AOC-BOC)} or
\eqn{(AOB+AOC-BOC)} or \eqn{(AOC+BOC-AOB)} or \ldots.
However, the most time consuming step is the
evaluation of \code{\link[mvtnorm]{pmvnorm}}.
}
\note{
The package \pkg{gpclib} is required to produce the
\code{tristrip}, since this is not implemented in \pkg{rgeos}
(as of version 0.3-25).
The restricted license of \pkg{gpclib} (commercial use prohibited)
has to be accepted explicitly via
\code{\link{gpclibPermit}()} prior to using \code{polyCub.exact.Gauss}.
}
\examples{
# see example(polyCub)
}
\references{
Abramowitz, M. and Stegun, I. A. (1972).
Handbook of Mathematical Functions with Formulas, Graphs, and Mathematical
Tables. New York: Dover Publications.
}
\seealso{
\code{\link{circleCub.Gauss}} for quasi-exact cubature of the
isotropic Gaussian density over a circular domain.

Other polyCub-methods: \code{\link{polyCub.SV}},
  \code{\link{polyCub.iso}},
  \code{\link{polyCub.midpoint}}, \code{\link{polyCub}}
}
\keyword{math}
\keyword{spatial}
