% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breaks-log.R
\name{minor_breaks_log}
\alias{minor_breaks_log}
\title{Minor breaks for log-10 axes}
\usage{
minor_breaks_log(detail = NULL, smallest = NULL)
}
\arguments{
\item{detail}{Any of \code{1}, \code{5} and \code{10} to mark multiples of
powers, multiples of 5 of powers or just powers respectively.}

\item{smallest}{Smallest absolute value to mark when the range includes
negative numbers.}
}
\value{
A function to generate minor ticks.
}
\description{
This break function is designed to mark every power, multiples of 5 and/or 1
of that power for base 10.
}
\examples{
# Standard usage with log10 scale
demo_log10(c(1, 1e10), minor_breaks = minor_breaks_log())
# Increasing detail over many powers
demo_log10(c(1, 1e10), minor_breaks = minor_breaks_log(detail = 1))
# Adjusting until where to draw minor breaks
demo_continuous(
  c(-1000, 1000),
  transform = asinh_trans(),
  minor_breaks = minor_breaks_log(smallest = 1)
)
}
