% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_stars}
\alias{write_stars}
\alias{write_stars.stars}
\alias{write_stars.stars_proxy}
\title{write stars object to gdal dataset (typically: to file)}
\usage{
write_stars(obj, dsn, layer, ...)

\method{write_stars}{stars}(obj, dsn, layer = 1, ...,
  driver = detect.driver(dsn), options = character(0),
  type = "Float32", NA_value = NA_real_, update = FALSE)

\method{write_stars}{stars_proxy}(obj, dsn, layer = 1, ...,
  driver = detect.driver(dsn), options = character(0),
  type = "Float32", NA_value = NA_real_, chunk_size = c(dim(obj)[1],
  floor(2.5e+07/dim(obj)[1])), progress = TRUE)
}
\arguments{
\item{obj}{object of class \code{stars}}

\item{dsn}{gdal dataset (file) name}

\item{layer}{attribute name; if missing, the first attribute is written}

\item{...}{passed on to \link[sf]{gdal_write}}

\item{driver}{driver driver name; see \link[sf]{st_drivers}}

\item{options}{character vector with options}

\item{type}{character; output binary type, one of: \code{Byte} for eight bit unsigned integer, \code{UInt16} for sixteen bit unsigned integer, \code{Int16} for sixteen bit signed integer, \code{UInt32} for thirty two bit unsigned integer, \code{Int32} for thirty two bit signed integer, \code{Float32} for thirty two bit floating point, \code{Float64} for sixty four bit floating point.}

\item{NA_value}{non-NA value that should represent R's \code{NA} value in the target raster file; if set to \code{NA}, it will be ignored.}

\item{update}{logical; if \code{TRUE}, an existing file is being updated}

\item{chunk_size}{length two integer vector with the number of pixels (x, y) used in the read/write loop; see details.}

\item{progress}{logical; if \code{TRUE}, a progress bar is shown}
}
\description{
write stars object to gdal dataset (typically: to file)
}
\details{
\code{write_stars} first creates the target file, then updates it sequentially by writing blocks of \code{chunk_size}.
}
