<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">

  <!--
       driver file for the transformation of the RefDB manual refentry
       sections to man pages. We only provide a rather simplistic rendering
       of tables here.
       -->
  <xsl:import href="http://docbook.sourceforge.net/release/xsl/current/manpages/docbook.xsl"/>

  <!--
       the table and table/title templates are a workaround for two issues:
       1) the default output contains the character #160 representing a
          non-breaking space. This leads to groff errors on some systems
          (seen e.g. on Debian)
       2) the default output does not put the table title on a separate
          line, making the output somewhat hard on the eyes

       the downside of this poor-man's approach is that we lose automatic
       table numbering

       -->
  <xsl:template match="table|informaltable">
    <xsl:message>
      <xsl:value-of select="substring($VERSION,3,2)"/>
    </xsl:message>
    <xsl:choose>
      <xsl:when test="substring($VERSION,3,2) &gt;= 70">
        <xsl:apply-templates select="." mode="to.tbl">
          <xsl:with-param name="source" select="ancestor::refentry/refnamediv[1]/refname[1]"/>
        </xsl:apply-templates>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates mode="to.pp"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="table/title" mode="to.pp">
    <xsl:text>&#10;.PP&#10;\fBTable: </xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\fR&#10;.PP&#10;</xsl:text>
  </xsl:template>

  <xsl:template match="tbody" mode="to.pp">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="entry" mode="to.pp">
    <xsl:apply-templates/>
    <xsl:text> | </xsl:text>
  </xsl:template>

  <xsl:template match="row" mode="to.pp">
    <xsl:text>&#10;.PP&#10;| </xsl:text>
    <xsl:apply-templates/>
    <xsl:text>&#10;.PP&#10;</xsl:text>
  </xsl:template>

</xsl:stylesheet>
