///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "grad_grad.h"
#include "rheolef/ublas_matrix_range.h"
using namespace rheolef;
using namespace std;
using namespace ublas;

void 
grad_grad::operator() (const geo_element& K, ublas::matrix<Float>& a) const
{
  size_type n_comp = get_first_space().n_component();
  if (n_comp == 1) {
    build_grad_grad (K, a);
  }
  matrix<Float> ai;
  build_grad_grad (K, ai);
  size_type n1 = ai.size1();
  size_type n2 = ai.size2();
  a.resize (n_comp*n1, n_comp*n2);
  a.clear();
  for (size_type i = 0; i < n_comp; i++) {
    mr_set (a, range(i*n1,(i+1)*n1), range(i*n2,(i+1)*n2), ai);
  }
}
grad_grad::size_type
grad_grad::n_derivative() const
{
  return 2;
}
void
grad_grad::check_after_initialize () const
{
  // suppose also that multi-component spaces are homogeneous,
  // i.e. that all components have the same approx
  check_macro (get_first_space().n_component() == get_second_space().n_component(),
    "incompatible spaces for the `grad_grad' form.");
  if (is_weighted()) {
    fem_helper::valued_field_type valued = _wh.get_valued_type();
    if (valued != fem_helper::scalar
     && valued != fem_helper::tensorial
     && valued != fem_helper::unsymmetric_tensorial) {
        error_macro ("invalid weight for the grad_grad form");
    }
  }
}
