// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __coord_h__
#define __coord_h__

#include <string.h>

#include <iostream>
#include <sstream>
#include <iomanip>
using namespace std;

class Coord {
 public:
  enum InternalSystem {WINDOW, CANVAS, WIDGET, USER, REF, 
		       PANNER, MAGNIFIER, PS};

  enum CoordSystem {DATA, IMAGE, PHYSICAL, AMPLIFIER, DETECTOR, WCS, 
		    WCSA, WCSB, WCSC, WCSD, WCSE, WCSF, WCSG, WCSH, WCSI,
		    WCSJ, WCSK, WCSL, WCSM, WCSN, WCSO, WCSP, WCSQ, WCSR,
		    WCSS, WCST, WCSU, WCSV, WCSW, WCSX, WCSY, WCSZ, WCS0};

  enum SkyFrame {FK4, FK4_NO_E, FK5, ICRS, GALACTIC, SUPERGALACTIC, 
		 ECLIPTIC, HELIOECLIPTIC};

  enum SkyFormat {DEGREES, SEXAGESIMAL};
  enum SkyDist {DEGREE, ARCMIN, ARCSEC};
  enum AngleFormat {DEG, RAD};
  enum Orientation {NORMAL, XX, YY, XY};

  static char *coordSystemStr_[];
  static char *skyFrameStr_[];
  static char *skyFormatStr_[];
  static char *skyDistStr_[];

  public:
  void listCoordSystem(ostream&, CoordSystem, SkyFrame, int, int);
  void listDistSystem(ostream&, CoordSystem, SkyDist, int);
  void listProsCoordSystem(ostream&, CoordSystem, SkyFrame);

  void strToCoordSystem(const char*, CoordSystem, CoordSystem*, SkyFrame*);
  void strToSkyFormat(const char*, SkyFormat*);
  void strToSkyDist(const char*, SkyDist*);
  void strToDistSystem(const char*, CoordSystem, CoordSystem*, SkyDist*);
  void strToAngleFormat(const char*, AngleFormat*);

  char* coordSystemStr(int ii) {return coordSystemStr_[ii];}
  char* skyFrameStr(int ii) {return skyFrameStr_[ii];}
  char* skyFormatStr(int ii) {return skyFormatStr_[ii];}
  char* skyDistStr(int ii) {return skyDistStr_[ii];}
};

extern Coord coord;

#endif
