#include <list>
#include <string>
#include <sigxconfig.h>
#ifdef SIGC_MSC
#include <Winsock2.h>
#else
#include <netinet/in.h> // in_addr_t
#endif
#include <sigc++/connection.h>


struct IPResolverThread::ThreadData
{
	std::list<in_addr_t> m_msgQueue;
	sigc::connection m_connIdle;
	in_addr_t m_nIPPrev; ///< previous ip
	std::string m_strHost;
	bool m_bStopResolving;
	
	IPResolverThread::signal_resolving_stopped_t m_sigResolvingStopped;
	IPResolverThread::signal_finished_t m_sigFinished;
	IPResolverThread::signal_resolved_t m_sigResolved;
	
	ThreadData();
};
