/* Public domain. */

#include "bytestr.h"
#include "stralloc.h"
#include "dns_transmit.h"

static int doit (stralloc *work, unsigned int workbase, char const *rule)
{
  unsigned int colon ;
  unsigned int prefixlen ;

  char ch = *rule++ ;
  if ((ch != '?') && (ch != '=') && (ch != '*') && (ch != '-')) return 1 ;
  colon = str_chr(rule, ':') ;
  if (!rule[colon]) return 1 ;

  if (work->len - workbase < colon) return 1 ;
  prefixlen = work->len - workbase - colon ;
  if ((ch == '=') && prefixlen) return 1 ;
  if (case_diffb(rule, colon, work->s + workbase + prefixlen)) return 1 ;
  if (ch == '?')
  {
    if (byte_chr(work->s + workbase, prefixlen, '.') < prefixlen) return 1 ;
    if (byte_chr(work->s + workbase, prefixlen, '[') < prefixlen) return 1 ;
    if (byte_chr(work->s + workbase, prefixlen, ']') < prefixlen) return 1 ;
  }

  work->len = workbase + prefixlen ;
  if (ch == '-') work->len = workbase ;
  return stralloc_cats(work, rule + colon + 1) ;
}

int dns_ip4_qualify_rulesb (stralloc *out, stralloc *fqdn, char const *in, unsigned int inlen, char const *rules, unsigned int ruleslen)
{
  unsigned int fqdnbase = fqdn->len ;
  unsigned int outbase = out->len ;
  unsigned int i = 0, j = 0 ;
  unsigned int plus ;
  unsigned int fqdnlen ;

  if (!stralloc_catb(fqdn, in, inlen)) return -1 ;

  for (; j < ruleslen ; j++)
    if (!rules[j])
    {
      if (!doit(fqdn, fqdnbase, rules + i)) return -1 ;
      i = j + 1 ;
    }

  fqdnlen = fqdn->len - fqdnbase ;
  plus = byte_chr(fqdn->s + fqdnbase, fqdnlen, '+') ;
  if (plus >= fqdnlen) return dns_ip4b(out, fqdn->s + fqdnbase, fqdnlen) ;

  i = plus + 1 ;
  for (;;)
  {
    j = byte_chr(fqdn->s + fqdnbase + i, fqdnlen - i, '+') ;
    byte_copy(fqdn->s + fqdnbase + plus, j, fqdn->s + fqdnbase + i) ;
    fqdn->len = fqdnbase + plus + j ;
    if (dns_ip4b(out, fqdn->s + fqdnbase, fqdn->len - fqdnbase) == -1) return -1 ;
    if (out->len > outbase) return 0 ;
    i += j ;
    if (i >= fqdnlen) return 0 ;
    ++i ;
  }
}
