2.1 Vos premiers Beeps

# Vos premiers Beeps

Jetez un œil sur le code suivant :

```
play 70
```

C'est là que tout commence. Allez de l'avant, copiez et collez-le dans
la fenêtre de code en haut de l'application (le grand espace blanc en
dessous du bouton Run). Maintenant, pressez Run...

## Beep!

Intense. Pressez-le une nouvelle fois. Et encore. *Et encore...*

Woah, fou, je suis sûr que vous pourrez continuer à faire cela toute
la journée. Mais attendez, avant que vous ne vous perdiez dans un flot
infini de beeps, essayez de changer le nombre :

```
play 75
```

Entendez-vous la différence ? Essayez un nombre plus petit :

```
play 60

```

Ainsi, des nombres plus petits font des beeps plus grave et des nombres
plus grands font des beeps plus aigus. Juste comme sur un piano, les
touches de la partie basse (côté main gauche) font des notes plus graves
et celles de la partie haute (côté main droite) font des notes plus
aiguës. En fait, les nombres représentent réellement l'ordre des notes
sur le piano. `play 47` signifie réellement "joue la 47ème note" sur le
piano. Ce qui signifie que `play 48` désigne la note supérieure (la note
suivante vers la droite). Il faut juste noter que le 4ème octave du Do
(C en notation anglaise) est identifié par le nombre 60. Poursuivez et
jouez-le : `play 60`

*Ne vous inquiétez pas* si cela ne signifie rien pour vous - c'est ce
qu'il m'est arrivé au début quand j'ai commencé. Tout ce qui importe
maintenant est que vous sachiez que *les petits nombres font des beeps
graves* et que *les grands nombres font des beeps aigus*. 

## Accords

Jouez une note est vraiment plaisant, mais en jouer plusieurs en même
temps est encore mieux. Essayez-le :

```
play 72
play 75
play 79
```

Jazzy ! Ainsi quand vous écrivez plusieurs `play`s, ils sont tous joués
en même temps. Essayez-le vous-même - quels sont les nombres qui sonnent
bien ensemble ? Lesquels sonnent terrible ? Expérimentez, explorez et trouvez
ce qui est bien pour vous.

## Mélodie

Ainsi, jouer des notes et des accords est plaisant - mais comment
jouer une mélodie ? Que faire si vous voulez jouer une note après une
autre et pas en même temps ? Eh bien, c'est facile, vous avez juste
besoin de `sleep` entre les notes :

```
play 72
sleep 1
play 75
sleep 1
play 79
```

Comme c'est charmant, un petit arpège. Alors que signifie le `1` dans
`sleep 1` ? Eh bien, cela représente la *durée du sleep*. Ça signifie
réellement "dors pendant un temps musical", mais pour l'instant nous pouvons
penser qu'il s'agit de dormir pendant 1 seconde. Alors que faire si nous
voulons que notre arpège soit un peu plus rapide ? Eh bien, nous devons
utiliser des valeurs de sleep plus petites. Quel résultat pour la moitié,
c'est-à-dire `0.5` :

```
play 72
sleep 0.5
play 75
sleep 0.5
play 79
```

Remarquez comment ça joue plus rapidement. Maintenant, essayez vous-même,
changez les durées - utilisez différentes durées et différentes notes.

Une chose à essayer est les notes intermédiaires comme `play 52.3` et
`play 52.63`. Il n'est absolument pas nécessaire de coller aux notes
standardisées. Jouez et faites-vous plaisir.


## Les noms traditionnels des notes

Ceux qui connaissent déjà la notation musicale (ne vous inquiétez pas si
ce n'est pas votre cas - vous n'en n'avez pas besoin pour vous amuser)
pourraient aimer écrire une mélodie en utilisant les noms des notes comme
"Do" ou "Fa#" plutôt que des nombres. Sonic Pi a ce qu'il faut, mais en
notation anglaise (`A` pour "La", `B` pour "Si", `C` pour "Do", `D` pour
"Ré", `E` pour "Mi", `F` pour "Fa", `G` pour "Sol"). Vous pouvez faire
la chose suivante :

```
play :C
sleep 0.5
play :D
sleep 0.5
play :E
```

Notez de mettre des deux-points `:` devant votre nom de note de manière
qu'elle apparaisse en rose. Vous pouvez également spécifier l'octave en
ajoutant un nombre derrière le nom de la note :

```
play :C3
sleep 0.5
play :D3
sleep 0.5
play :E4
```

Si vous voulez faire un dièse, ajoutez un `s` (pour "sharp") derrière le nom
de la note, comme `play :Fs3` et si vous vouler faire un bémol, ajoutez un
`b` comme `play :Eb3`.

Maintenant *défoulez-vous* et faites-vous plaisir en faisant vos morceaux.
