5.2 イテレーション（反復）とループ

# イテレーション（反復）とループ

以前、`play`と`sample`のブロックを使って様々な音を作り出せること勉強しました。また、`sleep`を使うことによって、音の発生する時間をコントロールする方法も学びました。

これらの基本的なブロックを使用することで*多く*の楽しさがあることを理解してもらえたのではないかと思います。しかし、音楽を作るための強力なコードを学べば、その楽しさの次元はまた新しい段階に向かうでしょう。次のいくつかのセクションではパワフルな新しいツールを探っていきます。はじめはまず「イテレーション（反復）とループ」を学びます。

## リピート

何回か繰り返しを行うためにはどのようにコードを書いたらよいでしょう？例えばこのようなコードです。

```
play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25
```

これを3回繰り返したい場合、どうしたら良いでしょう？単純に考えればコピーして貼り付けを3回繰り返せば可能です。

```
play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25

play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25

play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25
```

ちょっと長過ぎますよね。もしサンプルの`:elec_plip`を変更させたい場合、どうしたら良いでしょうか？3ヶ所全部の`:elec_blup` をひとつひとつ変えなくてはいけません。さらに重要なことですが、繰り返しが50回とか1000回になったとしたらどうでしょう？変更したいコードがすごくたくさんになってしまいます。

## イテレーション（反復）

イテレーション（反復）とは、終了条件に達するまで一定の処理を繰り返すことです。実際、コードの繰り返しは`do`を*3回繰り返す*ことで簡単にできます。さあ、はじめましょう。先ほど学んだコードブロックを思い出してください。3回繰り返したいコードのブロックには「始まり」と「終わり」が記されていますね。そんな時にこの特別なコードである`3.times`を使いましょう。同じコードを*3回繰り返す*代わりに、`3.times`を書くことで、とても簡単に出来るようになります。その時にコードの最終行に`end`を書き入れることも忘れないようにしましょう。

```
3.times do
 play 50
 sleep 0.5
 sample :elec_blup
 sleep 0.5
 play 62
 sleep 0.25
end
```

コピーと貼り付けよりを繰り返すより、ずっと美しいコードになったと思いませんか？
このようにブロックを使うと、沢山の繰り返しの構造を作ることが出来るのです。

```
4.times do
 play 50
 sleep 0.5
end

8.times do
 play 55, release: 0.2
 sleep 0.25
end

4.times do
 play 50
 sleep 0.5
end
```

## イテレーション(反復)のネスティング(入れ子)

繰り返しの構造の中にさらなる繰り返しの機能を入れることによって面白いパターンを作ることが出来ます。例えば

```
4.times do
 sample :drum_heavy_kick
 2.times do
   sample :elec_blip2, rate: 2
   sleep 0.25
 end

 sample :elec_snare
 4.times do
   sample :drum_tom_mid_soft
   sleep 0.125
 end
end
```

## ループ（終わりのない繰り返し）

もしすごくたくさんの繰り返しをしたい場合、`1000.times do`のようにすごく大きな数値の繰り返しをさせることになってしまいます。こういった場合は、おそらく（stopボタンを押すまで）無限に繰り返す機能がほしいと思うでしょう。さあ、アーメンブレークのサンプルを無限にループさせてみましょう。

```
loop do
 sample :loop_amen
 sleep sample_duration :loop_amen
end
```

loopについて知っておかなくてはならない重要な点は、これはコードの中でブラックホールのように動いてしまう点です。一度loop機能が動いてしまうと、`stop`ボタンを押さない限り*永遠*に再生されるということです。つまり、これはloopの外にあるもコードは、いつまでたっても聞くことが出来ないということを意味しています。例えば、下の例で言うと、シンバルの音はloopの外にあるため、いつまでも動くことはありません。

```
loop do
 play 50
 sleep 1
end

sample :drum_cymbal_open
```

さあ、これで回数を指定するイテレーション(反復)と永遠に繰り返すループのコーディング方法を理解することができましたね!
