; LLVM IR generated by Intel SYCL Clang compiler (https://github.com/intel/llvm)

; SYCL source code for this test:
; void numbanks_attr() {
;   [[intelfpga::numbanks(16)]] int numbanks_var;
;
;   [[intelfpga::numbanks(2)]] struct numbanks_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; template <int A>
; void templ_numbanks_attr() {
;   [[intelfpga::numbanks(A)]] int templ_numbanks_var;
;
;   [[intelfpga::numbanks(A)]] struct templ_numbanks_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; void register_attr() {
;   [[intelfpga::register]] int register_var;
;
;   [[intelfpga::register]] struct register_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; void memory_attr() {
;   [[intelfpga::memory("MLAB")]] int memory_var[500];
;
;   [[intelfpga::memory("BLOCK_RAM")]] struct memory_st {
;     int field[10][2];
;   } s;
;   s.field[0][0] = {0};
; }
;
; void bankwidth_attr() {
;   [[intelfpga::bankwidth(8)]] int bankwidth_var;
;
;   [[intelfpga::bankwidth(4)]] struct bankwidth_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; template <int A>
; void templ_bankwidth_attr() {
;   [[intelfpga::bankwidth(A)]] int templ_bankwidth_var;
;
;   [[intelfpga::bankwidth(A)]] struct templ_bankwidth_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; void private_copies_attr() {
;   [[intelfpga::private_copies(4)]] int priv_copies_var;
;
;   [[intelfpga::private_copies(2)]] struct priv_copies_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; template <int A>
; void templ_private_copies_attr() {
;   [[intelfpga::private_copies(A)]] int templ_priv_copies_var;
;
;   [[intelfpga::private_copies(A)]] struct templ_priv_copies_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; void singlepump_attr() {
;   [[intelfpga::singlepump]] int singlepump_var;
;
;   [[intelfpga::singlepump]] struct singlepump_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; void doublepump_attr() {
;   [[intelfpga::doublepump]] int doublepump_var;
;
;   [[intelfpga::doublepump]] struct doublepump_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; void merge_attr() {
;   [[intelfpga::merge("foo", "depth")]] int merge_var;
;
;   [[intelfpga::merge("bar", "width")]] struct merge_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; void max_replicates_attr() {
;   [[intelfpga::max_replicates(4)]] int max_repl_var;
;
;   [[intelfpga::max_replicates(2)]] struct max_repl_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; template <int A>
; void templ_max_replicates_attr() {
;   [[intelfpga::max_replicates(A)]] int templ_max_repl_var;
;
;   [[intelfpga::max_replicates(A)]] struct templ_max_repl_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; void simple_dual_port_attr() {
;   [[intelfpga::simple_dual_port]] int simple_dual_port_var;
;
;   [[intelfpga::simple_dual_port]] struct simple_dual_port_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; void bank_bits_attr() {
;   [[intelfpga::numbanks(8), intelfpga::bank_bits(2, 1, 0)]] int bank_bits_var;
;
;   [[intelfpga::bank_bits(2)]] struct bank_bits_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; template <int A, int B>
; void templ_bank_bits_attr() {
;   [[intelfpga::bank_bits(A, B)]] int templ_bank_bits_var;
;
;   [[intelfpga::bank_bits(B)]] struct templ_bank_bits_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; void force_pow2_depth_attr() {
;   [[intelfpga::force_pow2_depth(0)]] int fp2d_var;
;
;   [[intelfpga::force_pow2_depth(1)]] struct fp2d_st {
;     int field;
;   } s;
;   s.field = 0;
; }
;
; template <int A>
; void templ_force_pow2_depth_attr() {
;   [[intelfpga::force_pow2_depth(A)]] int templ_fp2d_var;
;
;   [[intelfpga::force_pow2_depth(A)]] struct templ_fp2d_st {
;     int field;
;   } s;
;   s.field = 0;
; }
; void memory_attribute_on_array() {
;   [[intelfpga::register]] int register_var[32];
; }
;
; template <typename name, typename Func>
; __attribute__((sycl_kernel)) void kernel_single_task(Func kernelFunc) {
;   kernelFunc();
; }
;
; int main() {
;   kernel_single_task<class kernel_function>([]() {
;     numbanks_attr();
;     templ_numbanks_attr<4>();
;     register_attr();
;     memory_attr();
;     bankwidth_attr();
;     templ_bankwidth_attr<16>();
;     private_copies_attr();
;     templ_private_copies_attr<8>();
;     singlepump_attr();
;     doublepump_attr();
;     merge_attr();
;     max_replicates_attr();
;     templ_max_replicates_attr<8>();
;     simple_dual_port_attr();
;     bank_bits_attr();
;     templ_bank_bits_attr<4, 5>();
;     force_pow2_depth_attr();
;     templ_force_pow2_depth_attr<1>();
;     memory_attribute_on_array();
;   });
;   return 0;
; }

; LLVM IR compilation command:
; clang -cc1 -triple spir -disable-llvm-passes -fsycl-is-device -emit-llvm intel-fpga-local-var.cpp

; RUN: llvm-as %s -o %t.bc
; RUN: llvm-spirv %t.bc --spirv-ext=+SPV_INTEL_fpga_memory_attributes -o %t.spv
; RUN: llvm-spirv %t.spv --spirv-ext=+SPV_INTEL_fpga_memory_attributes -to-text -o %t.spt
; RUN: FileCheck < %t.spt %s --check-prefix=CHECK-SPIRV

; RUN: llvm-spirv -r %t.spv -o %t.rev.bc
; RUN: llvm-dis < %t.rev.bc | FileCheck %s --check-prefix=CHECK-LLVM

; RUN: llvm-spirv -spirv-text -r %t.spt -o %t.rev.bc
; RUN: llvm-dis < %t.rev.bc | FileCheck %s --check-prefix=CHECK-LLVM

; TODO: add a bunch of different tests for --spirv-ext option

; CHECK-SPIRV: Capability FPGAMemoryAttributesINTEL
; CHECK-SPIRV: Extension "SPV_INTEL_fpga_memory_attributes"
; CHECK-SPIRV: Decorate {{[0-9]+}} RegisterINTEL
; CHECK-SPIRV: Decorate {{[0-9]+}} MemoryINTEL "DEFAULT"
; CHECK-SPIRV: Decorate {{[0-9]+}} MemoryINTEL "MLAB"
; CHECK-SPIRV: Decorate {{[0-9]+}} MemoryINTEL "BLOCK_RAM"
; CHECK-SPIRV: Decorate {{[0-9]+}} NumbanksINTEL 2
; CHECK-SPIRV: Decorate {{[0-9]+}} NumbanksINTEL 4
; CHECK-SPIRV: Decorate {{[0-9]+}} NumbanksINTEL 8
; CHECK-SPIRV: Decorate {{[0-9]+}} NumbanksINTEL 16
; CHECK-SPIRV: Decorate {{[0-9]+}} BankwidthINTEL 4
; CHECK-SPIRV: Decorate {{[0-9]+}} BankwidthINTEL 8
; CHECK-SPIRV: Decorate {{[0-9]+}} BankwidthINTEL 16
; CHECK-SPIRV: Decorate {{[0-9]+}} MaxPrivateCopiesINTEL 2
; CHECK-SPIRV: Decorate {{[0-9]+}} MaxPrivateCopiesINTEL 4
; CHECK-SPIRV: Decorate {{[0-9]+}} MaxPrivateCopiesINTEL 8
; CHECK-SPIRV: Decorate {{[0-9]+}} SinglepumpINTEL
; CHECK-SPIRV: Decorate {{[0-9]+}} DoublepumpINTEL
; CHECK-SPIRV: Decorate {{[0-9]+}} MaxReplicatesINTEL 2
; CHECK-SPIRV: Decorate {{[0-9]+}} MaxReplicatesINTEL 4
; CHECK-SPIRV: Decorate {{[0-9]+}} MaxReplicatesINTEL 8
; CHECK-SPIRV: Decorate {{[0-9]+}} SimpleDualPortINTEL
; CHECK-SPIRV: Decorate {{[0-9]+}} MergeINTEL "foo" "depth"
; CHECK-SPIRV: Decorate {{[0-9]+}} MergeINTEL "bar" "width"
; CHECK-SPIRV: Decorate {{[0-9]+}} BankBitsINTEL 2
; CHECK-SPIRV: Decorate {{[0-9]+}} BankBitsINTEL 5
; CHECK-SPIRV: Decorate {{[0-9]+}} BankBitsINTEL 4 5
; CHECK-SPIRV: Decorate {{[0-9]+}} BankBitsINTEL 2 1 0
; CHECK-SPIRV: Decorate {{[0-9]+}} ForcePow2DepthINTEL 0
; CHECK-SPIRV: Decorate {{[0-9]+}} ForcePow2DepthINTEL 1

target datalayout = "e-p:32:32-i64:64-v16:16-v24:32-v32:32-v48:64-v96:128-v192:256-v256:256-v512:512-v1024:1024"
target triple = "spir"

%class.anon = type { i8 }
%struct.numbanks_st = type { i32 }
%struct.templ_numbanks_st = type { i32 }
%struct.register_st = type { i32 }
%struct.memory_st = type { [10 x [2 x i32]] }
%struct.bankwidth_st = type { i32 }
%struct.templ_bankwidth_st = type { i32 }
%struct.priv_copies_st = type { i32 }
%struct.templ_priv_copies_st = type { i32 }
%struct.singlepump_st = type { i32 }
%struct.doublepump_st = type { i32 }
%struct.merge_st = type { i32 }
%struct.max_repl_st = type { i32 }
%struct.templ_max_repl_st = type { i32 }
%struct.simple_dual_port_st = type { i32 }
%struct.bank_bits_st = type { i32 }
%struct.templ_bank_bits_st = type { i32 }
%struct.fp2d_st = type { i32 }
%struct.templ_fp2d_st = type { i32 }

; CHECK-LLVM: [[STR_NMB_VAR:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{numbanks:16}
; CHECK-LLVM: [[STR_NMB_SCT:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{numbanks:2}
; CHECK-LLVM: [[STR_NMB_TE1:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{numbanks:4}
; CHECK-LLVM: [[STR_NMB_TE2:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{numbanks:4}
; CHECK-LLVM: [[STR_REG_VAR:@[0-9_.]+]] = {{.*}}{register:1}
; CHECK-LLVM: [[STR_REG_SCT:@[0-9_.]+]] = {{.*}}{register:1}
; CHECK-LLVM: [[STR_MEM_VAR:@[0-9_.]+]] = {{.*}}{memory:MLAB}
; CHECK-LLVM: [[STR_MEM_SCT:@[0-9_.]+]] = {{.*}}{memory:BLOCK_RAM}
; CHECK-LLVM: [[STR_BWD_VAR:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{bankwidth:8}
; CHECK-LLVM: [[STR_BWD_SCT:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{bankwidth:4}
; CHECK-LLVM: [[STR_BWD_TE1:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{bankwidth:16}
; CHECK-LLVM: [[STR_BWD_TE2:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{bankwidth:16}
; CHECK-LLVM: [[STR_PRC_VAR:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{private_copies:4}
; CHECK-LLVM: [[STR_PRC_SCT:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{private_copies:2}
; CHECK-LLVM: [[STR_PRC_TE1:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{private_copies:8}
; CHECK-LLVM: [[STR_PRC_TE2:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{private_copies:8}
; CHECK-LLVM: [[STR_SNP_VAR:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{pump:1}
; CHECK-LLVM: [[STR_SNP_SCT:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{pump:1}
; CHECK-LLVM: [[STR_DBP_VAR:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{pump:2}
; CHECK-LLVM: [[STR_DBP_SCT:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{pump:2}
; CHECK-LLVM: [[STR_MRG_VAR:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{merge:foo:depth}
; CHECK-LLVM: [[STR_MRG_SCT:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{merge:bar:width}
; CHECK-LLVM: [[STR_MXR_VAR:@[0-9_.]+]] = {{.*}}{max_replicates:4}
; CHECK-LLVM: [[STR_MXR_SCT:@[0-9_.]+]] = {{.*}}{max_replicates:2}
; CHECK-LLVM: [[STR_MXR_TE1:@[0-9_.]+]] = {{.*}}{max_replicates:8}
; CHECK-LLVM: [[STR_MXR_TE2:@[0-9_.]+]] = {{.*}}{max_replicates:8}
; CHECK-LLVM: [[STR_SDP_VAR:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{simple_dual_port:1}
; CHECK-LLVM: [[STR_SDP_SCT:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{simple_dual_port:1}
; CHECK-LLVM: [[STR_BBT_VAR:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{numbanks:8}{bank_bits:2,1,0}
; CHECK-LLVM: [[STR_BBT_SCT:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{numbanks:2}{bank_bits:2}
; CHECK-LLVM: [[STR_BBT_TE1:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{numbanks:4}{bank_bits:4,5}
; CHECK-LLVM: [[STR_BBT_TE2:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{numbanks:2}{bank_bits:5}
; CHECK-LLVM: [[STR_FP2_VAR:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{force_pow2_depth:0}
; CHECK-LLVM: [[STR_FP2_SCT:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{force_pow2_depth:1}
; CHECK-LLVM: [[STR_FP2_TE1:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{force_pow2_depth:1}
; CHECK-LLVM: [[STR_FP2_TE2:@[0-9_.]+]] = {{.*}}{memory:DEFAULT}{force_pow2_depth:1}
; CHECK-LLVM: [[STR_REG_ARR:@[0-9_.]+]] = {{.*}}{register:1}
@.str = private unnamed_addr constant [42 x i8] c"{memory:DEFAULT}{sizeinfo:4}{numbanks:16}\00", section "llvm.metadata"
@.str.1 = private unnamed_addr constant [25 x i8] c"intel-fpga-local-var.cpp\00", section "llvm.metadata"
@.str.2 = private unnamed_addr constant [41 x i8] c"{memory:DEFAULT}{sizeinfo:4}{numbanks:2}\00", section "llvm.metadata"
@.str.3 = private unnamed_addr constant [41 x i8] c"{memory:DEFAULT}{sizeinfo:4}{numbanks:4}\00", section "llvm.metadata"
@.str.4 = private unnamed_addr constant [13 x i8] c"{register:1}\00", section "llvm.metadata"
@.str.5 = private unnamed_addr constant [30 x i8] c"{memory:MLAB}{sizeinfo:4,500}\00", section "llvm.metadata"
@.str.6 = private unnamed_addr constant [32 x i8] c"{memory:BLOCK_RAM}{sizeinfo:80}\00", section "llvm.metadata"
@.str.7 = private unnamed_addr constant [42 x i8] c"{memory:DEFAULT}{sizeinfo:4}{bankwidth:8}\00", section "llvm.metadata"
@.str.8 = private unnamed_addr constant [42 x i8] c"{memory:DEFAULT}{sizeinfo:4}{bankwidth:4}\00", section "llvm.metadata"
@.str.9 = private unnamed_addr constant [43 x i8] c"{memory:DEFAULT}{sizeinfo:4}{bankwidth:16}\00", section "llvm.metadata"
@.str.10 = private unnamed_addr constant [47 x i8] c"{memory:DEFAULT}{sizeinfo:4}{private_copies:4}\00", section "llvm.metadata"
@.str.11 = private unnamed_addr constant [47 x i8] c"{memory:DEFAULT}{sizeinfo:4}{private_copies:2}\00", section "llvm.metadata"
@.str.12 = private unnamed_addr constant [47 x i8] c"{memory:DEFAULT}{sizeinfo:4}{private_copies:8}\00", section "llvm.metadata"
@.str.13 = private unnamed_addr constant [37 x i8] c"{memory:DEFAULT}{sizeinfo:4}{pump:1}\00", section "llvm.metadata"
@.str.14 = private unnamed_addr constant [37 x i8] c"{memory:DEFAULT}{sizeinfo:4}{pump:2}\00", section "llvm.metadata"
@.str.15 = private unnamed_addr constant [46 x i8] c"{memory:DEFAULT}{sizeinfo:4}{merge:foo:depth}\00", section "llvm.metadata"
@.str.16 = private unnamed_addr constant [46 x i8] c"{memory:DEFAULT}{sizeinfo:4}{merge:bar:width}\00", section "llvm.metadata"
@.str.17 = private unnamed_addr constant [19 x i8] c"{max_replicates:4}\00", section "llvm.metadata"
@.str.18 = private unnamed_addr constant [19 x i8] c"{max_replicates:2}\00", section "llvm.metadata"
@.str.19 = private unnamed_addr constant [19 x i8] c"{max_replicates:8}\00", section "llvm.metadata"
@.str.20 = private unnamed_addr constant [49 x i8] c"{memory:DEFAULT}{sizeinfo:4}{simple_dual_port:1}\00", section "llvm.metadata"
@.str.21 = private unnamed_addr constant [58 x i8] c"{memory:DEFAULT}{sizeinfo:4}{numbanks:8}{bank_bits:2,1,0}\00", section "llvm.metadata"
@.str.22 = private unnamed_addr constant [54 x i8] c"{memory:DEFAULT}{sizeinfo:4}{numbanks:2}{bank_bits:2}\00", section "llvm.metadata"
@.str.23 = private unnamed_addr constant [56 x i8] c"{memory:DEFAULT}{sizeinfo:4}{numbanks:4}{bank_bits:4,5}\00", section "llvm.metadata"
@.str.24 = private unnamed_addr constant [54 x i8] c"{memory:DEFAULT}{sizeinfo:4}{numbanks:2}{bank_bits:5}\00", section "llvm.metadata"
@.str.25 = private unnamed_addr constant [49 x i8] c"{memory:DEFAULT}{sizeinfo:4}{force_pow2_depth:0}\00", section "llvm.metadata"
@.str.26 = private unnamed_addr constant [49 x i8] c"{memory:DEFAULT}{sizeinfo:4}{force_pow2_depth:1}\00", section "llvm.metadata"

; Function Attrs: norecurse nounwind
define spir_kernel void @_ZTSZ4mainE15kernel_function() #0 !kernel_arg_addr_space !4 !kernel_arg_access_qual !4 !kernel_arg_type !4 !kernel_arg_base_type !4 !kernel_arg_type_qual !4 {
entry:
  %0 = alloca %class.anon, align 1
  %1 = bitcast %class.anon* %0 to i8*
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %1) #5
  call spir_func void @"_ZZ4mainENK3$_0clEv"(%class.anon* %0)
  %2 = bitcast %class.anon* %0 to i8*
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %2) #5
  ret void
}

; Function Attrs: argmemonly nounwind willreturn
declare void @llvm.lifetime.start.p0i8(i64 immarg, i8* nocapture) #1

; Function Attrs: inlinehint norecurse nounwind
define internal spir_func void @"_ZZ4mainENK3$_0clEv"(%class.anon* %this) #2 align 2 {
entry:
  %this.addr = alloca %class.anon*, align 4
  store %class.anon* %this, %class.anon** %this.addr, align 4, !tbaa !5
  %this1 = load %class.anon*, %class.anon** %this.addr, align 4
  call spir_func void @_Z13numbanks_attrv()
  call spir_func void @_Z19templ_numbanks_attrILi4EEvv()
  call spir_func void @_Z13register_attrv()
  call spir_func void @_Z11memory_attrv()
  call spir_func void @_Z14bankwidth_attrv()
  call spir_func void @_Z20templ_bankwidth_attrILi16EEvv()
  call spir_func void @_Z19private_copies_attrv()
  call spir_func void @_Z25templ_private_copies_attrILi8EEvv()
  call spir_func void @_Z15singlepump_attrv()
  call spir_func void @_Z15doublepump_attrv()
  call spir_func void @_Z10merge_attrv()
  call spir_func void @_Z19max_replicates_attrv()
  call spir_func void @_Z25templ_max_replicates_attrILi8EEvv()
  call spir_func void @_Z21simple_dual_port_attrv()
  call spir_func void @_Z14bank_bits_attrv()
  call spir_func void @_Z20templ_bank_bits_attrILi4ELi5EEvv()
  call spir_func void @_Z21force_pow2_depth_attrv()
  call spir_func void @_Z27templ_force_pow2_depth_attrILi1EEvv()
  call spir_func void @_Z25memory_attribute_on_arrayv()
  ret void
}

; Function Attrs: argmemonly nounwind willreturn
declare void @llvm.lifetime.end.p0i8(i64 immarg, i8* nocapture) #1

; Function Attrs: nounwind willreturn
declare void @llvm.var.annotation(i8*, i8*, i8*, i32, i8*) #4

; Function Attrs: norecurse nounwind
define spir_func void @_Z13numbanks_attrv() #3 {
entry:
  %numbanks_var = alloca i32, align 4
  %s = alloca %struct.numbanks_st, align 4
  %0 = bitcast i32* %numbanks_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %numbanks_var1 = bitcast i32* %numbanks_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_NMB_VAR]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %numbanks_var1, i8* getelementptr inbounds ([42 x i8], [42 x i8]* @.str, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 2, i8* null)
  %1 = bitcast %struct.numbanks_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.numbanks_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_NMB_SCT]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([41 x i8], [41 x i8]* @.str.2, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 6, i8* null)
  %field = getelementptr inbounds %struct.numbanks_st, %struct.numbanks_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !9
  %2 = bitcast %struct.numbanks_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %numbanks_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr spir_func void @_Z19templ_numbanks_attrILi4EEvv() #3 {
entry:
  %templ_numbanks_var = alloca i32, align 4
  %s = alloca %struct.templ_numbanks_st, align 4
  %0 = bitcast i32* %templ_numbanks_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %templ_numbanks_var1 = bitcast i32* %templ_numbanks_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_NMB_TE1]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %templ_numbanks_var1, i8* getelementptr inbounds ([41 x i8], [41 x i8]* @.str.3, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 12, i8* null)
  %1 = bitcast %struct.templ_numbanks_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.templ_numbanks_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_NMB_TE2]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([41 x i8], [41 x i8]* @.str.3, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 16, i8* null)
  %field = getelementptr inbounds %struct.templ_numbanks_st, %struct.templ_numbanks_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !12
  %2 = bitcast %struct.templ_numbanks_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %templ_numbanks_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define spir_func void @_Z13register_attrv() #3 {
entry:
  %register_var = alloca i32, align 4
  %s = alloca %struct.register_st, align 4
  %0 = bitcast i32* %register_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %register_var1 = bitcast i32* %register_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_REG_VAR]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %register_var1, i8* getelementptr inbounds ([13 x i8], [13 x i8]* @.str.4, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 21, i8* null)
  %1 = bitcast %struct.register_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.register_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_REG_SCT]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([13 x i8], [13 x i8]* @.str.4, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 25, i8* null)
  %field = getelementptr inbounds %struct.register_st, %struct.register_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !14
  %2 = bitcast %struct.register_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %register_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define spir_func void @_Z11memory_attrv() #3 {
entry:
  %memory_var = alloca [500 x i32], align 4
  %s = alloca %struct.memory_st, align 4
  %0 = bitcast [500 x i32]* %memory_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 2000, i8* %0) #5
  %memory_var1 = bitcast [500 x i32]* %memory_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_MEM_VAR]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %memory_var1, i8* getelementptr inbounds ([30 x i8], [30 x i8]* @.str.5, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 30, i8* null)
  %1 = bitcast %struct.memory_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 80, i8* %1) #5
  %s2 = bitcast %struct.memory_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_MEM_SCT]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([32 x i8], [32 x i8]* @.str.6, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 34, i8* null)
  %field = getelementptr inbounds %struct.memory_st, %struct.memory_st* %s, i32 0, i32 0
  %arrayidx = getelementptr inbounds [10 x [2 x i32]], [10 x [2 x i32]]* %field, i64 0, i64 0
  %arrayidx3 = getelementptr inbounds [2 x i32], [2 x i32]* %arrayidx, i64 0, i64 0
  store i32 0, i32* %arrayidx3, align 4, !tbaa !16
  %2 = bitcast %struct.memory_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 80, i8* %2) #5
  %3 = bitcast [500 x i32]* %memory_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 2000, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define spir_func void @_Z14bankwidth_attrv() #3 {
entry:
  %bankwidth_var = alloca i32, align 4
  %s = alloca %struct.bankwidth_st, align 4
  %0 = bitcast i32* %bankwidth_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %bankwidth_var1 = bitcast i32* %bankwidth_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_BWD_VAR]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %bankwidth_var1, i8* getelementptr inbounds ([42 x i8], [42 x i8]* @.str.7, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 39, i8* null)
  %1 = bitcast %struct.bankwidth_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.bankwidth_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_BWD_SCT]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([42 x i8], [42 x i8]* @.str.8, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 43, i8* null)
  %field = getelementptr inbounds %struct.bankwidth_st, %struct.bankwidth_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !17
  %2 = bitcast %struct.bankwidth_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %bankwidth_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr spir_func void @_Z20templ_bankwidth_attrILi16EEvv() #3 {
entry:
  %templ_bankwidth_var = alloca i32, align 4
  %s = alloca %struct.templ_bankwidth_st, align 4
  %0 = bitcast i32* %templ_bankwidth_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %templ_bankwidth_var1 = bitcast i32* %templ_bankwidth_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_BWD_TE1]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %templ_bankwidth_var1, i8* getelementptr inbounds ([43 x i8], [43 x i8]* @.str.9, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 49, i8* null)
  %1 = bitcast %struct.templ_bankwidth_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.templ_bankwidth_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_BWD_TE2]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([43 x i8], [43 x i8]* @.str.9, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 53, i8* null)
  %field = getelementptr inbounds %struct.templ_bankwidth_st, %struct.templ_bankwidth_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !19
  %2 = bitcast %struct.templ_bankwidth_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %templ_bankwidth_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define spir_func void @_Z19private_copies_attrv() #3 {
entry:
  %priv_copies_var = alloca i32, align 4
  %s = alloca %struct.priv_copies_st, align 4
  %0 = bitcast i32* %priv_copies_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %priv_copies_var1 = bitcast i32* %priv_copies_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_PRC_VAR]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %priv_copies_var1, i8* getelementptr inbounds ([47 x i8], [47 x i8]* @.str.10, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 58, i8* null)
  %1 = bitcast %struct.priv_copies_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.priv_copies_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_PRC_SCT]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([47 x i8], [47 x i8]* @.str.11, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 62, i8* null)
  %field = getelementptr inbounds %struct.priv_copies_st, %struct.priv_copies_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !21
  %2 = bitcast %struct.priv_copies_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %priv_copies_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr spir_func void @_Z25templ_private_copies_attrILi8EEvv() #3 {
entry:
  %templ_priv_copies_var = alloca i32, align 4
  %s = alloca %struct.templ_priv_copies_st, align 4
  %0 = bitcast i32* %templ_priv_copies_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %templ_priv_copies_var1 = bitcast i32* %templ_priv_copies_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_PRC_TE1]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %templ_priv_copies_var1, i8* getelementptr inbounds ([47 x i8], [47 x i8]* @.str.12, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 68, i8* null)
  %1 = bitcast %struct.templ_priv_copies_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.templ_priv_copies_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_PRC_TE2]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([47 x i8], [47 x i8]* @.str.12, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 72, i8* null)
  %field = getelementptr inbounds %struct.templ_priv_copies_st, %struct.templ_priv_copies_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !23
  %2 = bitcast %struct.templ_priv_copies_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %templ_priv_copies_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define spir_func void @_Z15singlepump_attrv() #3 {
entry:
  %singlepump_var = alloca i32, align 4
  %s = alloca %struct.singlepump_st, align 4
  %0 = bitcast i32* %singlepump_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %singlepump_var1 = bitcast i32* %singlepump_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_SNP_VAR]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %singlepump_var1, i8* getelementptr inbounds ([37 x i8], [37 x i8]* @.str.13, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 77, i8* null)
  %1 = bitcast %struct.singlepump_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.singlepump_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_SNP_SCT]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([37 x i8], [37 x i8]* @.str.13, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 81, i8* null)
  %field = getelementptr inbounds %struct.singlepump_st, %struct.singlepump_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !25
  %2 = bitcast %struct.singlepump_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %singlepump_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define spir_func void @_Z15doublepump_attrv() #3 {
entry:
  %doublepump_var = alloca i32, align 4
  %s = alloca %struct.doublepump_st, align 4
  %0 = bitcast i32* %doublepump_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %doublepump_var1 = bitcast i32* %doublepump_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_DBP_VAR]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %doublepump_var1, i8* getelementptr inbounds ([37 x i8], [37 x i8]* @.str.14, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 86, i8* null)
  %1 = bitcast %struct.doublepump_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.doublepump_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_DBP_SCT]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([37 x i8], [37 x i8]* @.str.14, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 90, i8* null)
  %field = getelementptr inbounds %struct.doublepump_st, %struct.doublepump_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !27
  %2 = bitcast %struct.doublepump_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %doublepump_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define spir_func void @_Z10merge_attrv() #3 {
entry:
  %merge_var = alloca i32, align 4
  %s = alloca %struct.merge_st, align 4
  %0 = bitcast i32* %merge_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %merge_var1 = bitcast i32* %merge_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_MRG_VAR]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %merge_var1, i8* getelementptr inbounds ([46 x i8], [46 x i8]* @.str.15, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 95, i8* null)
  %1 = bitcast %struct.merge_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.merge_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_MRG_SCT]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([46 x i8], [46 x i8]* @.str.16, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 99, i8* null)
  %field = getelementptr inbounds %struct.merge_st, %struct.merge_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !29
  %2 = bitcast %struct.merge_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %merge_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define spir_func void @_Z19max_replicates_attrv() #3 {
entry:
  %max_repl_var = alloca i32, align 4
  %s = alloca %struct.max_repl_st, align 4
  %0 = bitcast i32* %max_repl_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %max_repl_var1 = bitcast i32* %max_repl_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_MXR_VAR]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %max_repl_var1, i8* getelementptr inbounds ([19 x i8], [19 x i8]* @.str.17, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 104, i8* null)
  %1 = bitcast %struct.max_repl_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.max_repl_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_MXR_SCT]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([19 x i8], [19 x i8]* @.str.18, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 108, i8* null)
  %field = getelementptr inbounds %struct.max_repl_st, %struct.max_repl_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !31
  %2 = bitcast %struct.max_repl_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %max_repl_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr spir_func void @_Z25templ_max_replicates_attrILi8EEvv() #3 {
entry:
  %templ_max_repl_var = alloca i32, align 4
  %s = alloca %struct.templ_max_repl_st, align 4
  %0 = bitcast i32* %templ_max_repl_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %templ_max_repl_var1 = bitcast i32* %templ_max_repl_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_MXR_TE1]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %templ_max_repl_var1, i8* getelementptr inbounds ([19 x i8], [19 x i8]* @.str.19, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 114, i8* null)
  %1 = bitcast %struct.templ_max_repl_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.templ_max_repl_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_MXR_TE2]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([19 x i8], [19 x i8]* @.str.19, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 118, i8* null)
  %field = getelementptr inbounds %struct.templ_max_repl_st, %struct.templ_max_repl_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !33
  %2 = bitcast %struct.templ_max_repl_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %templ_max_repl_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define spir_func void @_Z21simple_dual_port_attrv() #3 {
entry:
  %simple_dual_port_var = alloca i32, align 4
  %s = alloca %struct.simple_dual_port_st, align 4
  %0 = bitcast i32* %simple_dual_port_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %simple_dual_port_var1 = bitcast i32* %simple_dual_port_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_SDP_VAR]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %simple_dual_port_var1, i8* getelementptr inbounds ([49 x i8], [49 x i8]* @.str.20, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 123, i8* null)
  %1 = bitcast %struct.simple_dual_port_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.simple_dual_port_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_SDP_SCT]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([49 x i8], [49 x i8]* @.str.20, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 127, i8* null)
  %field = getelementptr inbounds %struct.simple_dual_port_st, %struct.simple_dual_port_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !35
  %2 = bitcast %struct.simple_dual_port_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %simple_dual_port_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define spir_func void @_Z14bank_bits_attrv() #3 {
entry:
  %bank_bits_var = alloca i32, align 4
  %s = alloca %struct.bank_bits_st, align 4
  %0 = bitcast i32* %bank_bits_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %bank_bits_var1 = bitcast i32* %bank_bits_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_BBT_VAR]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %bank_bits_var1, i8* getelementptr inbounds ([58 x i8], [58 x i8]* @.str.21, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 132, i8* null)
  %1 = bitcast %struct.bank_bits_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.bank_bits_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_BBT_SCT]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([54 x i8], [54 x i8]* @.str.22, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 136, i8* null)
  %field = getelementptr inbounds %struct.bank_bits_st, %struct.bank_bits_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !37
  %2 = bitcast %struct.bank_bits_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %bank_bits_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr spir_func void @_Z20templ_bank_bits_attrILi4ELi5EEvv() #3 {
entry:
  %templ_bank_bits_var = alloca i32, align 4
  %s = alloca %struct.templ_bank_bits_st, align 4
  %0 = bitcast i32* %templ_bank_bits_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %templ_bank_bits_var1 = bitcast i32* %templ_bank_bits_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_BBT_TE1]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %templ_bank_bits_var1, i8* getelementptr inbounds ([56 x i8], [56 x i8]* @.str.23, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 142, i8* null)
  %1 = bitcast %struct.templ_bank_bits_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.templ_bank_bits_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_BBT_TE2]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([54 x i8], [54 x i8]* @.str.24, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 146, i8* null)
  %field = getelementptr inbounds %struct.templ_bank_bits_st, %struct.templ_bank_bits_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !39
  %2 = bitcast %struct.templ_bank_bits_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %templ_bank_bits_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define spir_func void @_Z21force_pow2_depth_attrv() #3 {
entry:
  %fp2d_var = alloca i32, align 4
  %s = alloca %struct.fp2d_st, align 4
  %0 = bitcast i32* %fp2d_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %fp2d_var1 = bitcast i32* %fp2d_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_FP2_VAR]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %fp2d_var1, i8* getelementptr inbounds ([49 x i8], [49 x i8]* @.str.25, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 151, i8* null)
  %1 = bitcast %struct.fp2d_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.fp2d_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_FP2_SCT]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([49 x i8], [49 x i8]* @.str.26, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 155, i8* null)
  %field = getelementptr inbounds %struct.fp2d_st, %struct.fp2d_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !41
  %2 = bitcast %struct.fp2d_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %fp2d_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr spir_func void @_Z27templ_force_pow2_depth_attrILi1EEvv() #3 {
entry:
  %templ_fp2d_var = alloca i32, align 4
  %s = alloca %struct.templ_fp2d_st, align 4
  %0 = bitcast i32* %templ_fp2d_var to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %0) #5
  %templ_fp2d_var1 = bitcast i32* %templ_fp2d_var to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_FP2_TE1]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %templ_fp2d_var1, i8* getelementptr inbounds ([49 x i8], [49 x i8]* @.str.26, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 161, i8* null)
  %1 = bitcast %struct.templ_fp2d_st* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1) #5
  %s2 = bitcast %struct.templ_fp2d_st* %s to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_FP2_TE2]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %s2, i8* getelementptr inbounds ([49 x i8], [49 x i8]* @.str.26, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 165, i8* null)
  %field = getelementptr inbounds %struct.templ_fp2d_st, %struct.templ_fp2d_st* %s, i32 0, i32 0
  store i32 0, i32* %field, align 4, !tbaa !43
  %2 = bitcast %struct.templ_fp2d_st* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %2) #5
  %3 = bitcast i32* %templ_fp2d_var to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %3) #5
  ret void
}

; Function Attrs: convergent noinline norecurse nounwind optnone mustprogress
define dso_local spir_func void @_Z25memory_attribute_on_arrayv() #2 {
entry:
  %register_var = alloca [32 x i32], align 4
  %register_var.ascast = addrspacecast [32 x i32]* %register_var to [32 x i32] addrspace(4)*
  %register_var.ascast1 = bitcast [32 x i32] addrspace(4)* %register_var.ascast to i8 addrspace(4)*
  %register_var.ascast2 = addrspacecast i8 addrspace(4)* %register_var.ascast1 to i8*
  ; CHECK-LLVM: call void @llvm.var.annotation(i8* %{{[a-zA-Z0-9_.]+}}, i8* getelementptr inbounds ([{{[0-9]+}} x i8], [{{[0-9]+}} x i8]* [[STR_REG_ARR]], i32 0, i32 0), i8* undef, i32 undef, i8* undef)
  call void @llvm.var.annotation(i8* %register_var.ascast2, i8* getelementptr inbounds ([13 x i8], [13 x i8]* @.str.4, i32 0, i32 0), i8* getelementptr inbounds ([25 x i8], [25 x i8]* @.str.1, i32 0, i32 0), i32 2, i8* null)
  ret void
}

attributes #0 = { norecurse nounwind "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="none" "less-precise-fpmad"="false" "min-legal-vector-width"="0" "no-infs-fp-math"="false" "no-jump-tables"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "sycl-module-id"="intel-fpga-local-var.cpp" "uniform-work-group-size"="true" "unsafe-fp-math"="false" "use-soft-float"="false" }
attributes #1 = { argmemonly nounwind willreturn }
attributes #2 = { inlinehint norecurse nounwind "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="none" "less-precise-fpmad"="false" "min-legal-vector-width"="0" "no-infs-fp-math"="false" "no-jump-tables"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "unsafe-fp-math"="false" "use-soft-float"="false" }
attributes #3 = { norecurse nounwind "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="none" "less-precise-fpmad"="false" "min-legal-vector-width"="0" "no-infs-fp-math"="false" "no-jump-tables"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "unsafe-fp-math"="false" "use-soft-float"="false" }
attributes #4 = { nounwind willreturn }
attributes #5 = { nounwind }

!llvm.module.flags = !{!0}
!opencl.spir.version = !{!1}
!spirv.Source = !{!2}
!llvm.ident = !{!3}

!0 = !{i32 1, !"wchar_size", i32 4}
!1 = !{i32 1, i32 2}
!2 = !{i32 4, i32 100000}
!3 = !{!"clang version 11.0.0"}
!4 = !{}
!5 = !{!6, !6, i64 0}
!6 = !{!"any pointer", !7, i64 0}
!7 = !{!"omnipotent char", !8, i64 0}
!8 = !{!"Simple C++ TBAA"}
!9 = !{!10, !11, i64 0}
!10 = !{!"_ZTSZ13numbanks_attrvE11numbanks_st", !11, i64 0}
!11 = !{!"int", !7, i64 0}
!12 = !{!13, !11, i64 0}
!13 = !{!"_ZTSZ19templ_numbanks_attrILi4EEvvE17templ_numbanks_st", !11, i64 0}
!14 = !{!15, !11, i64 0}
!15 = !{!"_ZTSZ13register_attrvE11register_st", !11, i64 0}
!16 = !{!11, !11, i64 0}
!17 = !{!18, !11, i64 0}
!18 = !{!"_ZTSZ14bankwidth_attrvE12bankwidth_st", !11, i64 0}
!19 = !{!20, !11, i64 0}
!20 = !{!"_ZTSZ20templ_bankwidth_attrILi16EEvvE18templ_bankwidth_st", !11, i64 0}
!21 = !{!22, !11, i64 0}
!22 = !{!"_ZTSZ19private_copies_attrvE14priv_copies_st", !11, i64 0}
!23 = !{!24, !11, i64 0}
!24 = !{!"_ZTSZ25templ_private_copies_attrILi8EEvvE20templ_priv_copies_st", !11, i64 0}
!25 = !{!26, !11, i64 0}
!26 = !{!"_ZTSZ15singlepump_attrvE13singlepump_st", !11, i64 0}
!27 = !{!28, !11, i64 0}
!28 = !{!"_ZTSZ15doublepump_attrvE13doublepump_st", !11, i64 0}
!29 = !{!30, !11, i64 0}
!30 = !{!"_ZTSZ10merge_attrvE8merge_st", !11, i64 0}
!31 = !{!32, !11, i64 0}
!32 = !{!"_ZTSZ19max_replicates_attrvE11max_repl_st", !11, i64 0}
!33 = !{!34, !11, i64 0}
!34 = !{!"_ZTSZ25templ_max_replicates_attrILi8EEvvE17templ_max_repl_st", !11, i64 0}
!35 = !{!36, !11, i64 0}
!36 = !{!"_ZTSZ21simple_dual_port_attrvE19simple_dual_port_st", !11, i64 0}
!37 = !{!38, !11, i64 0}
!38 = !{!"_ZTSZ14bank_bits_attrvE12bank_bits_st", !11, i64 0}
!39 = !{!40, !11, i64 0}
!40 = !{!"_ZTSZ20templ_bank_bits_attrILi4ELi5EEvvE18templ_bank_bits_st", !11, i64 0}
!41 = !{!42, !11, i64 0}
!42 = !{!"_ZTSZ21force_pow2_depth_attrvE7fp2d_st", !11, i64 0}
!43 = !{!44, !11, i64 0}
!44 = !{!"_ZTSZ27templ_force_pow2_depth_attrILi1EEvvE13templ_fp2d_st", !11, i64 0}
