/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import java.util.HashMap;
import java.util.Map;
import uk.me.nxg.unity.FunctionDefinition;
import uk.me.nxg.unity.FunctionDefinitionMap;
import uk.me.nxg.unity.Syntax;

class UnityFunctionDefinitionMap
extends FunctionDefinitionMap {
    FunctionDefinition[] fd;
    Map<String, FunctionDefinition> functionLookup = new HashMap<String, FunctionDefinition>();
    Map<Syntax, Map<FunctionDefinition, String>> allMappings = new HashMap<Syntax, Map<FunctionDefinition, String>>();

    UnityFunctionDefinitionMap() {
    }

    @Override
    public FunctionDefinitionMap.Resolver getResolver(Syntax syntax) {
        final Map<FunctionDefinition, String> map = this.allMappings.get((Object)syntax);
        if (map == null) {
            return null;
        }
        return new FunctionDefinitionMap.Resolver(){

            @Override
            public FunctionDefinition getFunctionDefinition(String string) {
                return UnityFunctionDefinitionMap.this.functionLookup.get(string);
            }

            @Override
            public String getFunctionName(FunctionDefinition functionDefinition) {
                return (String)map.get(functionDefinition);
            }
        };
    }

    @Override
    UnityFunctionDefinitionMap initialize() {
        this.fd = new FunctionDefinition[13];
        this.fd[0] = new FunctionDefinition("Common Logarithm (base 10)", "\\log", "log");
        this.fd[1] = new FunctionDefinition("Natural Logarithm", "\\ln", "ln");
        this.fd[2] = new FunctionDefinition("Exponential", "\\exp", "exp");
        this.fd[3] = new FunctionDefinition("Square root", "\\sqrt", "sqrt");
        this.fd[4] = new FunctionDefinition("Sine", "\\sin", "sin");
        this.fd[5] = new FunctionDefinition("Cosine", "\\cos", "cos");
        this.fd[6] = new FunctionDefinition("Tangent", "\\tan", "tan");
        this.fd[7] = new FunctionDefinition("Arc sine", "\\arcsin", "asin");
        this.fd[8] = new FunctionDefinition("Arc cosine", "\\arccos", "acos");
        this.fd[9] = new FunctionDefinition("Arc tangent", "\\arctan", "atan");
        this.fd[10] = new FunctionDefinition("Hyperbolic sine", "\\sinh", "sinh");
        this.fd[11] = new FunctionDefinition("Hyperbolic cosine", "\\cosh", "cosh");
        this.fd[12] = new FunctionDefinition("Hyperbolic tangent", "\\tanh", "tanh");
        HashMap<FunctionDefinition, String> hashMap = new HashMap<FunctionDefinition, String>();
        hashMap.put(this.fd[2], "exp");
        this.functionLookup.put("exp", this.fd[2]);
        hashMap.put(this.fd[1], "ln");
        this.functionLookup.put("ln", this.fd[1]);
        hashMap.put(this.fd[0], "log");
        this.functionLookup.put("log", this.fd[0]);
        hashMap.put(this.fd[3], "sqrt");
        this.functionLookup.put("sqrt", this.fd[3]);
        this.allMappings.put(Syntax.FITS, hashMap);
        hashMap = new HashMap();
        hashMap.put(this.fd[8], "acos");
        this.functionLookup.put("acos", this.fd[8]);
        hashMap.put(this.fd[7], "asin");
        this.functionLookup.put("asin", this.fd[7]);
        hashMap.put(this.fd[9], "atan");
        this.functionLookup.put("atan", this.fd[9]);
        hashMap.put(this.fd[5], "cos");
        this.functionLookup.put("cos", this.fd[5]);
        hashMap.put(this.fd[11], "cosh");
        this.functionLookup.put("cosh", this.fd[11]);
        hashMap.put(this.fd[2], "exp");
        this.functionLookup.put("exp", this.fd[2]);
        hashMap.put(this.fd[1], "ln");
        this.functionLookup.put("ln", this.fd[1]);
        hashMap.put(this.fd[0], "log");
        this.functionLookup.put("log", this.fd[0]);
        hashMap.put(this.fd[4], "sin");
        this.functionLookup.put("sin", this.fd[4]);
        hashMap.put(this.fd[10], "sinh");
        this.functionLookup.put("sinh", this.fd[10]);
        hashMap.put(this.fd[3], "sqrt");
        this.functionLookup.put("sqrt", this.fd[3]);
        hashMap.put(this.fd[6], "tan");
        this.functionLookup.put("tan", this.fd[6]);
        hashMap.put(this.fd[12], "tanh");
        this.functionLookup.put("tanh", this.fd[12]);
        this.allMappings.put(Syntax.OGIP, hashMap);
        hashMap = new HashMap();
        this.allMappings.put(Syntax.CDS, hashMap);
        hashMap = new HashMap();
        hashMap.put(this.fd[2], "exp");
        this.functionLookup.put("exp", this.fd[2]);
        hashMap.put(this.fd[1], "ln");
        this.functionLookup.put("ln", this.fd[1]);
        hashMap.put(this.fd[0], "log");
        this.functionLookup.put("log", this.fd[0]);
        hashMap.put(this.fd[3], "sqrt");
        this.functionLookup.put("sqrt", this.fd[3]);
        this.allMappings.put(Syntax.VOUNITS, hashMap);
        return this;
    }
}

