/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 *
 * Check that we get the correct data from model and proxy.
 * .
 * subcommander/
 * subcommander/abc.c
 * subcommander-test/
 * subcommander-test/xyz.c
 */

#include "WcViewSimilarFolderNames.h"
#include "WcViewItemTest.h"
#include "util-test/AssertionTraitString.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "subcommander/WcViewItemModel.h"
#include "subcommander/WcViewTreeItemModel.h"
#include "subcommander/WcViewTreeProxyModel.h"
#include "util/String.h"

// qt
#include <QtCore/QVariant>


enum {
  RootFolder,
  Subcommander,
  SubcommanderTest
};


void WcViewSimilarFolderNames::setUp()
{
  _model = new WcViewTreeItemModel( sc::String("invisible/sc"), new WcViewItemDataTest() );
  _proxy = new WcViewTreeProxyModel();
  _proxy->setSourceModel(_model);
  _proxy->setCurrentPath( sc::String("invisible/sc") );
  _proxy->setFilterFlat(true);
  TextStatusFilter filter;
  filter.set(StatusModified);
  _proxy->setFilterTextStatus(filter);

  // setup input data for the model
  setup(RootFolder,"invisible/sc",true,false);
  setup(RootFolder,"invisible/sc/subcommander",true,false);
  setup(RootFolder,"invisible/sc/subcommander-test",true,false);

  setup(Subcommander,"invisible/sc/subcommander",true,false);
  setup(Subcommander,"invisible/sc/subcommander/abc.c",false,true);

  setup(SubcommanderTest,"invisible/sc/subcommander-test",true,false);
  setup(SubcommanderTest,"invisible/sc/subcommander-test/xyz.c",false,true);
}

void WcViewSimilarFolderNames::tearDown()
{
  delete _model;
  delete _proxy;
}

void WcViewSimilarFolderNames::showAllAfterRootFolderAdd()
{
  insert( _model, RootFolder );

  QModelIndex idx = _model->index(0,0,QModelIndex());
  assertIndex( idx, "invisible/sc" );
  assertIndex( idx.child(0,0), "invisible/sc/subcommander" );
  assertIndex( idx.child(1,0), "invisible/sc/subcommander-test" );
  CPPUNIT_ASSERT_EQUAL( false, idx.child(2,0).isValid() );
}

void WcViewSimilarFolderNames::showAllAfterSubcommanderAdd()
{
  insert( _model, RootFolder );
  insert( _model, Subcommander );

  QModelIndex idx = _model->index(0,0,QModelIndex());
  assertIndex( idx, "invisible/sc" );
  assertIndex( idx.child(0,0), "invisible/sc/subcommander" );
  assertIndex( idx.child(1,0), "invisible/sc/subcommander-test" );
  CPPUNIT_ASSERT_EQUAL( false, idx.child(2,0).isValid() );

  QModelIndex cidx0 = idx.child(0,0);
  assertIndex( cidx0.child(0,0), "invisible/sc/subcommander/abc.c" );
  CPPUNIT_ASSERT_EQUAL( false, cidx0.child(1,0).isValid() );

  QModelIndex cidx1 = idx.child(1,0);
  CPPUNIT_ASSERT_EQUAL( false, cidx1.child(0,0).isValid() );
}

void WcViewSimilarFolderNames::showAllAfterSubcommanderTestAdd()
{
  insert( _model, RootFolder );
  insert( _model, Subcommander );
  insert( _model, SubcommanderTest );

  QModelIndex idx = _model->index(0,0,QModelIndex());
  assertIndex( idx, "invisible/sc" );
  assertIndex( idx.child(0,0), "invisible/sc/subcommander" );
  assertIndex( idx.child(1,0), "invisible/sc/subcommander-test" );
  CPPUNIT_ASSERT_EQUAL( false, idx.child(2,0).isValid() );

  QModelIndex cidx0 = idx.child(0,0);
  assertIndex( cidx0.child(0,0), "invisible/sc/subcommander/abc.c" );
  CPPUNIT_ASSERT_EQUAL( false, cidx0.child(1,0).isValid() );

  QModelIndex cidx1 = idx.child(1,0);
  assertIndex( cidx1.child(0,0), "invisible/sc/subcommander-test/xyz.c" );
  CPPUNIT_ASSERT_EQUAL( false, cidx1.child(1,0).isValid() );
}

void WcViewSimilarFolderNames::showOnlyRootAfterRootFolderAdd()
{
  insert( _proxy, RootFolder );

  QModelIndex idx = _proxy->index(0,0);
  assertIndex( idx, "invisible/sc" );
  CPPUNIT_ASSERT_EQUAL( false, idx.child(0,0).isValid() );
  CPPUNIT_ASSERT_EQUAL( false, idx.child(1,0).isValid() );
}

void WcViewSimilarFolderNames::showOnlyChildAfterSubcommanderAdd()
{
  insert( _proxy, RootFolder );
  insert( _proxy, Subcommander );

  QModelIndex idx = _proxy->index(0,0);
  assertIndex( idx, "invisible/sc" );

  assertIndex( idx.child(0,0), "invisible/sc/subcommander" );
  CPPUNIT_ASSERT_EQUAL( false, idx.child(1,0).isValid() );

  QModelIndex cidx = idx.child(0,0);
  assertIndex( cidx.child(0,0), "invisible/sc/subcommander/abc.c" );
  CPPUNIT_ASSERT_EQUAL( false, cidx.child(1,0).isValid() );
}

void WcViewSimilarFolderNames::showBothChildsAfterSubcommanderTestAdd()
{
  insert( _proxy, RootFolder );
  insert( _proxy, Subcommander );
  insert( _proxy, SubcommanderTest );

  QModelIndex idx = _proxy->index(0,0);
  assertIndex( idx, "invisible/sc" );

  assertIndex( idx.child(0,0), "invisible/sc/subcommander" );
  assertIndex( idx.child(1,0), "invisible/sc/subcommander-test" );
  CPPUNIT_ASSERT_EQUAL( false, idx.child(2,0).isValid() );

  QModelIndex cidx0 = idx.child(0,0);
  assertIndex( cidx0.child(0,0), "invisible/sc/subcommander/abc.c" );
  CPPUNIT_ASSERT_EQUAL( false, cidx0.child(1,0).isValid() );

  QModelIndex cidx1 = idx.child(1,0);
  assertIndex( cidx1.child(0,0), "invisible/sc/subcommander-test/xyz.c" );
  CPPUNIT_ASSERT_EQUAL( false, cidx1.child(1,0).isValid() );
}

void WcViewSimilarFolderNames::setup( long idx, const char* path, bool dir, bool changed )
{
  _items[idx].push_back(WcViewItemPtr(new WcViewItemTest(sc::String(path),dir,changed)));
}

void WcViewSimilarFolderNames::insert( WcViewItemModel* model, long dataIdx )
{
  model->remove( _items[dataIdx].front()->path() );
  model->insert( _items[dataIdx].front()->path(), _items[dataIdx] );
}

void WcViewSimilarFolderNames::assertIndex( const QModelIndex& idx, const char* expected )
{
  sc::String actual = idx.data(WcViewItemModel::NameRole).value<sc::String>();
  CPPUNIT_ASSERT_EQUAL( sc::String(expected), actual );
}
