---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              structures, indices, empilement d'indices, plusieurs indices, 
              opérateur, sommation
---

# Comment empiler des indices sous les opérateurs ?

## Avec l'extension <ctanpkg:mathtools>

L'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) dispose d'une commande
`\substack`. Elle permet de placer plusieurs lignes 
[d'indices](/4_domaines_specialises/mathematiques/structures/indices/start)
sous un opérateur en les séparant par la commande `\\`.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\[
  S_I = \sum_{%
    \substack{(i,j) \in I^2 \\
    i \neq j}}
    x_i + x_j
\]
\end{document}
```

Si le centrage des indices ne vous satisfait pas, l'extension propose 
une autre solution avec l'environnement `subarray` où vous pouvez déterminer
l'alignement souhaité (avec les choix classiques propres aux 
environnements de tableau présentés à la question 
"[](/3_composition/tableaux/construire_un_tableau)"). Voici 
par exemple un alignement à gauche avec `l` (pour *left*) dans l'exemple 
ci-dessous :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\[
  S_I = \sum_{%
    \begin{subarray}{c}
      (i,j) \in I^2 \\
      i \neq j
    \end{subarray}
  }
  x_i + x_j
\]
\end{document}
```


:::{sources}
- [Indices et exposants en folie](https://www.elzevir.fr/imj/latex/tips.html#indices), 
  par Manuel Pégourié-Gonnard
:::