from typing import Any

class Composable:
    def __init__(self, wrapped) -> None: ...
    def as_string(self, context) -> None: ...
    def __add__(self, other): ...
    def __mul__(self, n): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...

class Composed(Composable):
    def __init__(self, seq) -> None: ...
    @property
    def seq(self): ...
    def as_string(self, context): ...
    def __iter__(self): ...
    def __add__(self, other): ...
    def join(self, joiner): ...

class SQL(Composable):
    def __init__(self, string) -> None: ...
    @property
    def string(self): ...
    def as_string(self, context): ...
    def format(self, *args, **kwargs): ...
    def join(self, seq): ...

class Identifier(Composable):
    def __init__(self, *strings) -> None: ...
    @property
    def strings(self): ...
    @property
    def string(self): ...
    def as_string(self, context): ...

class Literal(Composable):
    @property
    def wrapped(self): ...
    def as_string(self, context): ...

class Placeholder(Composable):
    def __init__(self, name: Any | None = ...) -> None: ...
    @property
    def name(self): ...
    def as_string(self, context): ...

NULL: Any
DEFAULT: Any
