"""
Meta information for npapi <-> "native" types
"""

def get_meta_info_for_type (t):
    baseTypes = {"gchar*":
                 {"validator": "NPVARIANT_IS_STRING"
                  , "can_free": True
                  , 'create_var': True
                  , 'creator': 'create_safe_string_for (&args[%d])'
                  , 'null': '""'
                  , 'nullable': True
                  , 'to_variant': 'STRINGZ_TO_NPVARIANT'}

                 , "gint":
                 {"validator": "NPVARIANT_IS_INT32"
                  , "can_free": False
                  , 'create_var': True
                  , 'creator': 'NPVARIANT_TO_INT32 (args[%d])'
                  , 'null': '0'
                  , 'nullable': False
                  , 'to_variant': 'INT32_TO_NPVARIANT'}

                 , "guint64":
                 {"validator": "NPVARIANT_IS_DOUBLE"
                  , "can_free": False
                  , 'create_var': True
                  , 'creator': 'NPVARIANT_TO_DOUBLE (args[%d])'
                  , 'null': '0'
                  , 'nullable': False
                  , 'to_variant': 'INT32_TO_NPVARIANT'}

                 , "guint":
                 {"validator": "NPVARIANT_IS_INT32"
                  , "can_free": False
                  , 'create_var': True
                  , 'creator': 'NPVARIANT_TO_INT32 (args[%d])'
                  , 'null': '0'
                  , 'nullable': False
                  , 'to_variant': 'INT32_TO_NPVARIANT'}

                 , "gboolean":
                 {"validator": "NPVARIANT_IS_BOOLEAN"
                  , "can_free": False
                  , 'create_var': True
                  , 'creator': 'NPVARIANT_TO_BOOLEAN (args[%d])'
                  , 'null': 'false'
                  , 'nullable': False
                  , 'to_variant': 'BOOLEAN_TO_NPVARIANT'}

                 , "gsize":
                 {"validator": "NPVARIANT_IS_INT32"
                  , "can_free": False
                  , 'create_var': True
                  ,  'creator': 'NPVARIANT_TO_INT32 (args[%d])'
                  , 'null': '0'
                  , 'nullable': False
                  , 'to_variant': 'INT32_TO_NPVARIANT'}

                 , "gdouble":
                 {"validator": "NPVARIANT_IS_DOUBLE"
                  , "can_free": False
                  , 'create_var': True
                  , 'creator': 'NPVARIANT_TO_BOOLEAN (args[%d])'
                  , 'null': '0.0'
                  , 'nullable': False
                  , 'to_variant': 'DOUBLE_TO_NPVARIANT'}

                 , "void":
                 {"validator": "NPVARIANT_IS_VOID"
                  , "can_free": False
                  , 'create_var': False
                  , 'creator': None
                  , 'null': None
                  , 'nullable': False
                  , 'to_variant': 'VOID_TO_NPVARIANT'}

                 , "gpointer":
                 {"validator": "NPVARIANT_IS_OBJECT"
                  , "can_free": False
                  , 'create_var': True
                  , 'creator': None
                  , 'null': 'NULL'
                  , 'nullable': True
                  , 'to_variant': 'OBJECT_TO_NPVARIANT'}
             }
    
    # defaults to object
    other = {'validator': 'NPVARIANT_IS_OBJECT'
             , 'can_free': False
             , 'create_var': True
             , 'creator': '(void*) ((wrapped_void_ptr_t *) args[%d].value.objectValue)->pWrapped'
             , 'null': 'NULL'
             , 'nullable': True
             , 'to_variant': 'OBJECT_TO_NPVARIANT'}

    t = _strip_type_qualifiers(t).strip()
    info = baseTypes.has_key (t) and baseTypes[t] or other
    return info

def _strip_type_qualifiers (t):
    qualifiers = "const"    
    return t.strip ().replace (qualifiers, "").replace (" ", "")

