// -*- Mode: C++; indent-tabs-mode: nil; tab-width: 2 -*-
/*
 * Copyright (C) 2014 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Marco Trevisan <marco.trevisan@canonical.com>
 */

#ifndef UNITY_DECORATIONS_MENU_LAYOUT
#define UNITY_DECORATIONS_MENU_LAYOUT

#include <UnityCore/GLibSource.h>
#include "DecorationsWidgets.h"
#include "MenuManager.h"

namespace unity
{
namespace decoration
{
class MenuDropdown;

class MenuLayout : public Layout
{
public:
  typedef std::shared_ptr<MenuLayout> Ptr;

  MenuLayout(menu::Manager::Ptr const&, CompWindow*);

  nux::Property<bool> active;
  nux::Property<bool> show_now;

  void Setup();
  bool ActivateMenu(std::string const& entry_id);
  bool ActivateMenu(CompPoint const&);
  void ChildrenGeometries(indicator::EntryLocationMap&) const;
  std::string const& MenubarId() const;

protected:
  void DoRelayout() override;
  std::string GetName() const override { return "MenuLayout"; }

private:
  void OnEntryMouseOwnershipChanged(bool);
  void OnEntryActiveChanged(bool);
  void OnEntryShowNowChanged(bool);

  menu::Manager::Ptr menu_manager_;
  CompWindow* win_;
  glib::Source::UniquePtr show_now_timeout_;
  std::shared_ptr<MenuDropdown> dropdown_;
  std::string menubar_id_;
};

} // decoration namespace
} // unity namespace

#endif // UNITY_DECORATIONS_MENU_LAYOUT
