/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTextureTransformNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseMultiTextureTransform
extends AbstractNode
implements VRMLTextureTransformNodeType {
    private static final String TRANSFORM_PROTO_MSG = "Proto does not describe a TextureTransform object";
    private static final String TRANSFORM_NODE_MSG = "Node does not describe a TextureTransform object";
    protected static final int FIELD_TEXTURETRANSFORM = 1;
    protected static final int LAST_MULTITEXTURETRANSFORM_INDEX = 1;
    private static final int NUM_FIELDS = 2;
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected ArrayList vfTextureTransform = new ArrayList();

    protected BaseMultiTextureTransform() {
        super("MultiTextureTransform");
        this.hasChanged = new boolean[2];
    }

    protected BaseMultiTextureTransform(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfTextureTransform.size()];
        this.vfTextureTransform.toArray(vRMLNodeTypeArray);
        for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
            vRMLNodeTypeArray[i].setupFinished();
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 51;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        vRMLFieldData.clear();
        switch (n) {
            case 1: {
                VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfTextureTransform.size()];
                this.vfTextureTransform.toArray(vRMLNodeTypeArray);
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = vRMLNodeTypeArray;
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = vRMLNodeTypeArray.length;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfTextureTransform.size()];
                    this.vfTextureTransform.toArray(vRMLNodeTypeArray);
                    vRMLNodeType.setValue(n2, vRMLNodeTypeArray, vRMLNodeTypeArray.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("TextureTransform sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("TextureTransform sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    this.vfTextureTransform.clear();
                }
                if (vRMLNodeType != null) {
                    this.addTextureTransformNode(vRMLNodeType);
                }
                if (this.inSetup) break;
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    this.vfTextureTransform.clear();
                }
                for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
                    this.addTextureTransformNode(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    protected void addTextureTransformNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            if (!(vRMLNodeType2 instanceof VRMLTextureTransformNodeType)) {
                throw new InvalidFieldValueException(TRANSFORM_PROTO_MSG);
            }
            this.vfTextureTransform.add(vRMLNodeType2);
        } else {
            if (!(vRMLNodeType instanceof VRMLTextureTransformNodeType)) {
                throw new InvalidFieldValueException(TRANSFORM_NODE_MSG);
            }
            this.vfTextureTransform.add(vRMLNodeType);
        }
    }

    static {
        nodeFields = new int[]{1, 0};
        fieldDecl = new VRMLFieldDeclaration[2];
        fieldMap = new HashMap(6);
        BaseMultiTextureTransform.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseMultiTextureTransform.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "textureTransform");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("textureTransform", n);
        fieldMap.put("set_textureTransform", n);
        fieldMap.put("textureTransform_changed", n);
    }
}

