/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.functions;

class CubicSegment {
    private double x1;
    private double x2;
    private double y1;
    private double y2;
    private double d1;
    private double d2;
    private double a;
    private double b;
    private double c;
    private double d;

    CubicSegment() {
    }

    CubicSegment(double d, double d2, double d3, double d4, double d5, double d6) {
        this.setData(d, d2, d3, d4, d5, d6);
    }

    void setData(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        if (d == d2) {
            throw new IllegalArgumentException("Attempt to make CubicSegment of length 0");
        }
        if (d > d2) {
            d7 = d;
            d = d2;
            d2 = d7;
            d7 = d3;
            d3 = d4;
            d4 = d7;
            d7 = d5;
            d5 = d6;
            d6 = d7;
        }
        this.x1 = d;
        this.x2 = d2;
        this.y1 = d3;
        this.y2 = d4;
        this.d1 = d5;
        this.d2 = d6;
        d7 = this.x2 - this.x1;
        this.a = this.y2 / (d7 * d7 * d7);
        this.b = this.d2 / (d7 * d7) - 3.0 * this.a;
        d7 = -d7;
        this.d = this.y1 / (d7 * d7 * d7);
        this.c = this.d1 / (d7 * d7) - 3.0 * this.d;
    }

    void setDerivativesFromNeighbors(double d, double d2, double d3, double d4) {
        double d5 = !Double.isNaN(d) && d < this.x1 ? (this.y2 - d2) / (this.x2 - d) : (this.y2 - this.y1) / (this.x2 - this.x1);
        double d6 = !Double.isNaN(d3) && d3 > this.x2 ? (d4 - this.y1) / (d3 - this.x1) : (this.y2 - this.y1) / (this.x2 - this.x1);
        this.setData(this.x1, this.x2, this.y1, this.y2, d5, d6);
    }

    double value(double d) {
        return this.derivativeValue(d, 0);
    }

    double derivativeValue(double d, int n) {
        switch (n) {
            case 0: {
                double d2 = d - this.x1;
                double d3 = d2 * d2;
                double d4 = d3 * d2;
                double d5 = d - this.x2;
                double d6 = d5 * d5;
                double d7 = d6 * d5;
                return this.a * d4 + this.b * d3 * d5 + this.c * d2 * d6 + this.d * d7;
            }
            case 1: {
                return (3.0 * this.a + this.b) * (d - this.x1) * (d - this.x1) + 2.0 * (this.b + this.c) * (d - this.x1) * (d - this.x2) + (3.0 * this.d + this.c) * (d - this.x2) * (d - this.x2);
            }
            case 2: {
                return 2.0 * ((3.0 * this.a + 2.0 * this.b + this.c) * (d - this.x1) + (3.0 * this.d + 2.0 * this.c + this.b) * (d - this.x2));
            }
            case 3: {
                return 6.0 * (2.0 * this.a + this.b + this.c);
            }
        }
        return 0.0;
    }
}

