#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <xs.h>

#include "xs_tools.h"

/* ------------------------------------------------------------- */

int main(int argc, char *argv[])
{
    struct xs_handle *xenstore = NULL;
    char **vec;
    char value[256];
    unsigned int count, rc;

    xenstore = xenstore_open(1,1,1,1);
    if (NULL == xenstore) {
	fprintf(stderr, "can't access xenstore, exiting\n");
	exit(1);
    }

    xs_watch(xenstore, "/", "token");
    for (;;) {
	vec = xs_read_watch(xenstore, &count);
	if (NULL == vec) {
	    fprintf(stderr,"xs_read_watch() failed\n");
	    exit(1);
	}
	switch (vec[XS_WATCH_PATH][0]) {
	case '/':
	    rc = xenstore_read(xenstore, vec[XS_WATCH_PATH], value, sizeof(value));
	    switch (rc) {
	    case -1: strcpy(value, "<error>");   break;
	    case -2: strcpy(value, "<deleted>"); break;
	    }
	    break;
	default:
	    strcpy(value, "<null>");
	    break;
	}
	printf("%-64s :  \"%s\"\n", vec[XS_WATCH_PATH], value);
	fflush(stdout);
	free(vec);
    }
}
